/*
 * Decompiled with CFR 0.152.
 */
package me.chillywilly.issosd.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import me.chillywilly.issosd.client.IssosdClient;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ISSModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private double pos_x;
    private double pos_y;
    private String up_sound;
    private String down_sound;
    private float up_sound_pitch;
    private float down_sound_pitch;
    public boolean mod_enabled;
    public boolean up_sound_enabled;
    public boolean down_sound_enabled;

    public void load() {
        File folder = new File(class_310.method_1551().field_1697, "config");
        File file = new File(folder, "issPiss.json");
        if (!file.exists()) {
            this.reset();
            return;
        }
        try (FileReader fr = new FileReader(file);){
            ISSModConfig obj = (ISSModConfig)GSON.fromJson((Reader)fr, ISSModConfig.class);
            this.setX(obj.getX());
            this.setY(obj.getY());
            this.setUpSound(obj.getUpSoundRaw());
            this.setDownSound(obj.getDownSoundRaw());
            this.setUpSoundPitch(obj.getUpSoundPitch());
            this.setDownSoundPitch(obj.getDownSoundPitch());
            this.setEnabled(obj.getEnabled());
            this.setUpSoundEnabled(obj.getUpSoundEnabled());
            this.setDownSoundEnabled(obj.getDownSoundEnabled());
            this.check();
        }
        catch (Exception e) {
            IssosdClient.LOGGER.error("Failed to read file {}", (Object)file.getName(), (Object)e);
        }
    }

    public void save() {
        File folder = new File(class_310.method_1551().field_1697, "config");
        if (!folder.isDirectory() && !folder.mkdirs()) {
            IssosdClient.LOGGER.error("Failed to create missing config folder");
            return;
        }
        File file = new File(folder, "issPiss.json");
        try (FileWriter fw = new FileWriter(file);){
            GSON.toJson((Object)this, ISSModConfig.class, (Appendable)fw);
            IssosdClient.LOGGER.info("Saved Config");
        }
        catch (Exception e) {
            IssosdClient.LOGGER.error("Failed to write file {}", (Object)file.getName(), (Object)e);
        }
    }

    public void reset() {
        this.pos_x = 0.5;
        this.pos_y = 0.0;
        this.up_sound_pitch = 1.0f;
        this.down_sound_pitch = 1.0f;
        this.up_sound = "minecraft:block.note_block.harp";
        this.down_sound = "minecraft:block.note_block.banjo";
        this.mod_enabled = true;
        this.up_sound_enabled = true;
        this.down_sound_enabled = true;
        this.save();
    }

    public void check() {
        boolean save = false;
        if (this.up_sound == null) {
            this.up_sound = "minecraft:block.note_block.harp";
            save = true;
        }
        if (this.down_sound == null) {
            this.down_sound = "minecraft:block.note_block.banjo";
        }
        if (save) {
            this.save();
        }
    }

    public double getX() {
        return this.pos_x;
    }

    public double getY() {
        return this.pos_y;
    }

    public void setX(double pos_x) {
        this.pos_x = pos_x;
    }

    public void setY(double pos_y) {
        this.pos_y = pos_y;
    }

    public class_2960 getUpSound() {
        this.check();
        String[] up_sound_split = this.up_sound.split(":");
        if (up_sound_split.length == 2) {
            try {
                return class_2960.method_60655((String)up_sound_split[0], (String)up_sound_split[1]);
            }
            catch (Exception e) {
                IssosdClient.LOGGER.warn("Exception occured during sound ID initialization: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return class_2960.method_60655((String)"unset", (String)"unset");
    }

    public class_2960 getDownSound() {
        this.check();
        String[] down_sound_split = this.down_sound.split(":");
        if (down_sound_split.length == 2) {
            try {
                return class_2960.method_60655((String)down_sound_split[0], (String)down_sound_split[1]);
            }
            catch (Exception e) {
                IssosdClient.LOGGER.warn("Exception occured during sound ID initialization: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return class_2960.method_60655((String)"unset", (String)"unset");
    }

    public String getUpSoundRaw() {
        this.check();
        return this.up_sound;
    }

    public String getDownSoundRaw() {
        this.check();
        return this.down_sound;
    }

    public float getUpSoundPitch() {
        return this.up_sound_pitch;
    }

    public float getDownSoundPitch() {
        return this.down_sound_pitch;
    }

    public void setUpSound(String sound) {
        this.up_sound = sound;
    }

    public void setDownSound(String sound) {
        this.down_sound = sound;
    }

    public void setUpSoundPitch(float pitch) {
        this.up_sound_pitch = pitch;
    }

    public void setDownSoundPitch(float pitch) {
        this.down_sound_pitch = pitch;
    }

    public boolean getEnabled() {
        return this.mod_enabled;
    }

    public boolean getUpSoundEnabled() {
        return this.up_sound_enabled;
    }

    public boolean getDownSoundEnabled() {
        return this.down_sound_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.mod_enabled = enabled;
    }

    public void setUpSoundEnabled(boolean enabled) {
        this.up_sound_enabled = enabled;
    }

    public void setDownSoundEnabled(boolean enabled) {
        this.down_sound_enabled = enabled;
    }
}

