/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DiskRecipe
extends CustomRecipe {
    private final Ingredient redstone = PlatformHelper.get().getRecipeIngredients().redstone();

    public DiskRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        boolean paperFound = false;
        boolean redstoneFound = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == Items.f_42516_) {
                if (paperFound) {
                    return false;
                }
                paperFound = true;
                continue;
            }
            if (this.redstone.test(stack)) {
                if (redstoneFound) {
                    return false;
                }
                redstoneFound = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) continue;
            return false;
        }
        return redstoneFound && paperFound;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() == Items.f_42516_ || this.redstone.test(stack) || (dye = ColourUtils.getStackColour(stack)) == null) continue;
            tracker.addColour(dye);
        }
        return DiskItem.createFromIDAndColour(-1, null, tracker.hasColour() ? tracker.getColour() : Colour.BLUE.getHex());
    }

    public boolean m_8004_(int x, int y) {
        return x >= 2 && y >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return DiskItem.createFromIDAndColour(-1, null, Colour.BLUE.getHex());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.DISK.get();
    }
}

