/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import java.util.Iterator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class ChatTableClientMessage
implements NetworkMessage<ClientNetworkContext> {
    private static final int MAX_LEN = 16;
    private final TableBuilder table;

    public ChatTableClientMessage(TableBuilder table) {
        if (table.getColumns() < 0) {
            throw new IllegalStateException("Cannot send an empty table");
        }
        this.table = table;
    }

    public ChatTableClientMessage(FriendlyByteBuf buf) {
        TableBuilder table;
        int i;
        String id = buf.m_130136_(16);
        int columns = buf.m_130242_();
        if (buf.readBoolean()) {
            Component[] headers = new Component[columns];
            for (i = 0; i < columns; ++i) {
                headers[i] = buf.m_130238_();
            }
            table = new TableBuilder(id, headers);
        } else {
            table = new TableBuilder(id);
        }
        int rows = buf.m_130242_();
        for (i = 0; i < rows; ++i) {
            Component[] row = new Component[columns];
            for (int j = 0; j < columns; ++j) {
                row[j] = buf.m_130238_();
            }
            table.row(row);
        }
        table.setAdditional(buf.m_130242_());
        this.table = table;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130072_(this.table.getId(), 16);
        buf.m_130130_(this.table.getColumns());
        buf.writeBoolean(this.table.getHeaders() != null);
        if (this.table.getHeaders() != null) {
            for (Component header : this.table.getHeaders()) {
                buf.m_130083_(header);
            }
        }
        buf.m_130130_(this.table.getRows().size());
        Iterator<Component[]> iterator = this.table.getRows().iterator();
        while (iterator.hasNext()) {
            Component[] row;
            for (Component column : row = (Component[])iterator.next()) {
                buf.m_130083_(column);
            }
        }
        buf.m_130130_(this.table.getAdditional());
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleChatTable(this.table);
    }

    @Override
    public MessageType<ChatTableClientMessage> type() {
        return NetworkMessages.CHAT_TABLE;
    }
}

