/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.core.util.PeripheralHelpers;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public final class WiredModemLocalPeripheral {
    private static final String NBT_PERIPHERAL_TYPE = "PeripheralType";
    private static final String NBT_PERIPHERAL_ID = "PeripheralId";
    private int id = -1;
    private @Nullable String type;
    private @Nullable IPeripheral peripheral;
    private final ComponentAccess<IPeripheral> peripherals;

    public WiredModemLocalPeripheral(ComponentAccess<IPeripheral> peripherals) {
        this.peripherals = peripherals;
    }

    public boolean attach(Level world, BlockPos origin, Direction direction) {
        IPeripheral oldPeripheral = this.peripheral;
        this.peripheral = this.getPeripheralFrom(world, origin, direction);
        IPeripheral peripheral = this.peripheral;
        if (peripheral == null) {
            return oldPeripheral != null;
        }
        String type = peripheral.getType();
        int id = this.id;
        if (id > 0 && this.type == null) {
            this.type = type;
        } else if (id < 0 || !type.equals(this.type)) {
            this.type = type;
            this.id = ServerContext.get(Nullability.assertNonNull(world.m_7654_())).getNextId("peripheral." + type);
        }
        return !PeripheralHelpers.equals(oldPeripheral, peripheral);
    }

    public boolean detach() {
        if (this.peripheral == null) {
            return false;
        }
        this.peripheral = null;
        return true;
    }

    public @Nullable String getConnectedName() {
        return this.peripheral != null ? this.type + "_" + this.id : null;
    }

    public boolean hasPeripheral() {
        return this.peripheral != null;
    }

    public void extendMap(Map<String, IPeripheral> peripherals) {
        if (this.peripheral != null) {
            peripherals.put(this.type + "_" + this.id, this.peripheral);
        }
    }

    public Map<String, IPeripheral> toMap() {
        return this.peripheral == null ? Map.of() : Map.of(this.type + "_" + this.id, this.peripheral);
    }

    public void write(CompoundTag tag, String suffix) {
        if (this.id >= 0) {
            tag.m_128405_(NBT_PERIPHERAL_ID + suffix, this.id);
        }
        if (this.type != null) {
            tag.m_128359_(NBT_PERIPHERAL_TYPE + suffix, this.type);
        }
    }

    public void read(CompoundTag tag, String suffix) {
        this.id = tag.m_128425_(NBT_PERIPHERAL_ID + suffix, 99) ? tag.m_128451_(NBT_PERIPHERAL_ID + suffix) : -1;
        this.type = tag.m_128425_(NBT_PERIPHERAL_TYPE + suffix, 8) ? tag.m_128461_(NBT_PERIPHERAL_TYPE + suffix) : null;
    }

    private @Nullable IPeripheral getPeripheralFrom(Level world, BlockPos pos, Direction direction) {
        BlockPos offset = pos.m_121945_(direction);
        if (world.m_8055_(offset).m_204336_(ComputerCraftTags.Blocks.PERIPHERAL_HUB_IGNORE)) {
            return null;
        }
        IPeripheral peripheral = this.peripherals.get(direction);
        return peripheral instanceof WiredModemPeripheral ? null : peripheral;
    }
}

