/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.core.computer.ComputerSide;
import net.minecraft.core.Direction;

public final class DirectionUtil {
    public static final int ALL_SIDES = 63;
    public static final Direction[] FACINGS = Direction.values();

    private DirectionUtil() {
    }

    public static ComputerSide toLocal(Direction front, Direction dir) {
        if (front.m_122434_() == Direction.Axis.Y) {
            front = Direction.NORTH;
        }
        if (dir == front) {
            return ComputerSide.FRONT;
        }
        if (dir == front.m_122424_()) {
            return ComputerSide.BACK;
        }
        if (dir == front.m_122428_()) {
            return ComputerSide.LEFT;
        }
        if (dir == front.m_122427_()) {
            return ComputerSide.RIGHT;
        }
        if (dir == Direction.UP) {
            return ComputerSide.TOP;
        }
        return ComputerSide.BOTTOM;
    }

    public static float toPitchAngle(Direction dir) {
        return switch (dir) {
            case Direction.DOWN -> 90.0f;
            case Direction.UP -> 270.0f;
            default -> 0.0f;
        };
    }

    public static boolean isSet(int mask, Direction direction) {
        return (mask & 1 << direction.ordinal()) != 0;
    }
}

