/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.AABB;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3fc;

public class DrawerModelGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData() {
        if (geometryDataLoaded) {
            return;
        }
        geometryDataLoaded = true;
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new));
    }

    private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, BlockDrawers ... blocks) {
        List<BlockElement> slotGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationIcon));
        List<BlockElement> countGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationCount));
        List<BlockElement> indicatorGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationInd));
        List<BlockElement> indicatorBaseGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationIndBase));
        for (BlockDrawers block : blocks) {
            if (block == null) continue;
            DrawerModelGeometry.populateGeometryData(block, slotGeo, BlockDrawers.GeometryType.Label);
            DrawerModelGeometry.populateGeometryData(block, countGeo, BlockDrawers.GeometryType.Count);
            DrawerModelGeometry.populateGeometryData(block, indicatorGeo, BlockDrawers.GeometryType.Indicator);
            DrawerModelGeometry.populateGeometryData(block, indicatorBaseGeo, BlockDrawers.GeometryType.IndicatorBase);
        }
    }

    private static void populateGeometryData(BlockDrawers block, List<BlockElement> info, BlockDrawers.GeometryType type) {
        if (block == null || info == null) {
            return;
        }
        int drawerCount = block.getDrawerCount();
        if (drawerCount > info.size()) {
            return;
        }
        block7: for (int i = 0; i < drawerCount; ++i) {
            Vector3fc from = info.get(i).from();
            Vector3fc to = info.get(i).to();
            AABB bound = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            switch (type) {
                case Slot: {
                    block.slotGeometry[i] = bound;
                    continue block7;
                }
                case Count: {
                    block.countGeometry[i] = bound;
                    continue block7;
                }
                case Label: {
                    block.labelGeometry[i] = bound;
                    continue block7;
                }
                case Indicator: {
                    block.indGeometry[i] = bound;
                    continue block7;
                }
                case IndicatorBase: {
                    block.indBaseGeometry[i] = bound;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlockModel getBlockModel(ResourceLocation location) {
        Resource iresource = null;
        InputStreamReader reader = null;
        try {
            iresource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(location);
            reader = new InputStreamReader(iresource.open(), StandardCharsets.UTF_8);
            BlockModel blockModel = BlockModel.fromStream((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            return blockModel;
        }
        catch (IOException e) {
            BlockModel blockModel = null;
            return blockModel;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private static List<BlockElement> getElements(BlockModel model) {
        if (model == null) {
            return new ArrayList<BlockElement>();
        }
        UnbakedGeometry unbakedGeometry = model.geometry();
        if (unbakedGeometry instanceof SimpleUnbakedGeometry) {
            SimpleUnbakedGeometry geo = (SimpleUnbakedGeometry)unbakedGeometry;
            return geo.elements();
        }
        return new ArrayList<BlockElement>();
    }
}

