/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.base.Suppliers;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.ForgeDrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.ForgeFramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ItemModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DecoratorRenderType;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.IForgeBlockStateModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements IForgeBlockStateModel {
    public static final ModelProperty<BlockState> BLOCKSTATE = new ModelProperty();
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;
    private static final List<DecoratorRenderType> decoratorRenderTypes = List.of(DecoratorRenderType.SOLID, DecoratorRenderType.CUTOUT, DecoratorRenderType.TRANSLUCENT);

    public PlatformDecoratedModel(BlockStateModel parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return modelData.derive().with(BLOCKSTATE, (Object)state).build();
    }

    public void collectParts(RandomSource random, List<BlockModelPart> dest, ModelData data, @Nullable ChunkSectionLayer renderType) {
        BlockState state = (BlockState)data.get(BLOCKSTATE);
        if (state == null) {
            this.parent.collectParts(random, dest, data, renderType);
            return;
        }
        Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(state, random, data);
        if (this.decorator.shouldRenderBase(supplier)) {
            this.parent.collectParts(random, dest, data, renderType);
        }
        Consumer<BlockStateModel> emitModel = model -> {
            if (model != null) {
                model.collectParts(random, dest, data, renderType);
            }
        };
        try {
            this.decorator.emitQuads(supplier, emitModel, DecoratorRenderType.fromItemType(renderType));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Collection<ChunkSectionLayer> getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.decorator.getRenderTypes(state).stream().map(DecoratorRenderType::toChunkType).toList();
    }

    public TextureAtlasSprite particleIcon(@NotNull ModelData data) {
        Item item;
        ItemStack side;
        MaterialData matData = null;
        if (data.has(ForgeDrawerModelProperties.MATERIAL)) {
            matData = new MaterialData((IFramedMaterials)data.get(ForgeDrawerModelProperties.MATERIAL));
        } else if (data.has(ForgeFramedModelProperties.MATERIAL)) {
            matData = new MaterialData((IFramedMaterials)data.get(ForgeFramedModelProperties.MATERIAL));
        }
        if (matData != null && (side = matData.getEffectiveSide()) != ItemStack.EMPTY && (item = side.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockItem.getBlock().defaultBlockState());
            return model.particleIcon();
        }
        return super.particleIcon(data);
    }

    public static class ItemRender<C extends ModelContext>
    extends ParentModel {
        PlatformDecoratedModel<C> parent;
        private ItemStack stack;

        public ItemRender(PlatformDecoratedModel<C> parent, ItemStack stack) {
            super(parent);
            this.parent = parent;
            this.stack = stack;
        }

        @Override
        public void collectParts(RandomSource randomSource, List<BlockModelPart> list) {
            this.collectParts(randomSource, list, null);
        }

        public void collectParts(RandomSource randomSource, List<BlockModelPart> list, DecoratorRenderType renderType) {
            ModelDecorator<ModelContext> decorator = this.parent.decorator;
            Supplier<ModelContext> supplier = () -> this.parent.contextSupplier.makeContext(this.stack);
            if (decorator.shouldRenderBase(supplier, this.stack)) {
                this.parent.collectParts(randomSource, list);
            }
            Consumer<BlockStateModel> emitModel = model -> {
                if (model != null) {
                    model.collectParts(randomSource, list);
                }
            };
            try {
                decorator.emitItemQuads(supplier, emitModel, this.stack, renderType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class PlatformDecoratedItemModel
    implements ItemModel {
        ResourceLocation location;
        String variant;
        PlatformDecoratedModel<?> parent;
        ItemRender<ModelContext> model;
        ItemStack stack;
        BlockState state;
        ModelRenderProperties properties;
        private final Supplier<Vector3f[]> extents;

        public PlatformDecoratedItemModel(ResourceLocation location, String variant, ModelRenderProperties properties) {
            this.location = location;
            this.variant = variant;
            this.properties = properties;
            this.extents = Suppliers.memoize(() -> {
                Vector3f[] ext = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
                return ext;
            });
        }

        public void update(ItemStackRenderState itemStackRenderState, ItemStack itemStack, ItemModelResolver itemModelResolver, ItemDisplayContext itemDisplayContext, @Nullable ClientLevel clientLevel, @Nullable ItemOwner itemOwner, int i) {
            BlockStateModel stored;
            itemStackRenderState.appendModelIdentityElement((Object)this);
            itemStackRenderState.appendModelIdentityElement((Object)itemStack);
            if (this.state == null) {
                String[] props;
                Optional blockOption = BuiltInRegistries.BLOCK.get(this.location);
                if (blockOption.isEmpty()) {
                    return;
                }
                Block block = (Block)((Holder.Reference)blockOption.get()).value();
                this.state = block.defaultBlockState();
                for (String prop : props = this.variant.split(",")) {
                    String[] keyVal = prop.split("=");
                    if (keyVal.length != 2) continue;
                    String key = keyVal[0].trim();
                    String value = keyVal[1].trim();
                    Property property = this.state.getBlock().getStateDefinition().getProperty(key);
                    if (property == null) continue;
                    this.state = PlatformDecoratedItemModel.setProperty(this.state, property, value);
                }
            }
            if (this.parent == null && (stored = ItemModelStore.models.get(this.state)) instanceof PlatformDecoratedModel) {
                PlatformDecoratedModel p;
                this.parent = p = (PlatformDecoratedModel)stored;
            }
            if (!(this.stack != null && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)itemStack) || this.parent == null)) {
                this.stack = itemStack;
                this.model = new ItemRender(this.parent, itemStack);
            }
            if (this.model != null) {
                HashMap<DecoratorRenderType, ItemStackRenderState.LayerRenderState> layers = new HashMap<DecoratorRenderType, ItemStackRenderState.LayerRenderState>();
                for (DecoratorRenderType renderType : decoratorRenderTypes) {
                    ArrayList<BlockModelPart> parts = new ArrayList<BlockModelPart>();
                    this.model.collectParts(null, parts, renderType);
                    if (parts.isEmpty()) continue;
                    if (!layers.containsKey((Object)renderType)) {
                        ItemStackRenderState.LayerRenderState renderState = itemStackRenderState.newLayer();
                        layers.put(renderType, renderState);
                        renderState.setRenderType(DecoratorRenderType.toItemType(renderType));
                        renderState.setExtents(this.extents);
                    }
                    for (BlockModelPart part : parts) {
                        ItemStackRenderState.LayerRenderState layer = (ItemStackRenderState.LayerRenderState)layers.get((Object)renderType);
                        this.properties.applyToLayer(layer, itemDisplayContext);
                        layer.prepareQuadList().addAll(part.getQuads(null));
                        for (Direction direction : Direction.values()) {
                            layer.prepareQuadList().addAll(part.getQuads(direction));
                        }
                    }
                }
            }
        }

        private static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, String valueName) {
            Optional parsed = property.getValue(valueName);
            return parsed.map(v -> (BlockState)state.setValue(property, v)).orElse(state);
        }

        public record Unbaked(ResourceLocation model, String variant) implements ItemModel.Unbaked
        {
            public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)Codec.STRING.fieldOf("variant").forGetter(Unbaked::variant)).apply((Applicative)builder, Unbaked::new));

            public MapCodec<? extends ItemModel.Unbaked> type() {
                return MAP_CODEC;
            }

            public ItemModel bake(ItemModel.BakingContext bakingContext) {
                ModelBaker modelbaker = bakingContext.blockModelBaker();
                ResolvedModel resolvedmodel = modelbaker.getModel(ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)"block/oak_full_drawers_2"));
                TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
                ModelRenderProperties modelrenderproperties = ModelRenderProperties.fromResolvedModel((ModelBaker)modelbaker, (ResolvedModel)resolvedmodel, (TextureSlots)textureslots);
                return new PlatformDecoratedItemModel(this.model, this.variant, modelrenderproperties);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
            }
        }
    }
}

