/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.SpriteReplacementModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DecoratorRenderType;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MaterialModelDecorator<C extends FramedModelContext>
extends ModelDecorator<C> {
    protected final DrawerModelStore.FrameMatSet matSet;
    protected final boolean shaded;
    private static final Map<BlockStateModel, Map<ResourceLocation, BlockStateModel>> replacementCache = new HashMap<BlockStateModel, Map<ResourceLocation, BlockStateModel>>();
    private static final List<DecoratorRenderType> defaultRenderList = List.of(DecoratorRenderType.SOLID);
    private static final List<DecoratorRenderType> defaultShadedRenderList = List.of(DecoratorRenderType.SOLID, DecoratorRenderType.TRANSLUCENT);

    public MaterialModelDecorator(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
        this.matSet = matSet;
        this.shaded = shaded;
    }

    @Override
    public boolean shouldRenderItem() {
        return true;
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return true;
        }
        MaterialData matData = context.materialData();
        return matData == null || matData.getEffectiveSide().isEmpty();
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier, ItemStack stack) {
        return this.shouldRenderBase(contextSupplier);
    }

    @Override
    public List<DecoratorRenderType> getRenderTypes(BlockState state) {
        if (this.shaded) {
            return defaultShadedRenderList;
        }
        return defaultRenderList;
    }

    @Override
    public void emitQuads(Supplier<C> contextSupplier, Consumer<BlockStateModel> emitModel, DecoratorRenderType renderType) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return;
        }
        MaterialData matData = context.materialData();
        if (matData != null && !matData.getEffectiveSide().isEmpty()) {
            boolean shouldRender;
            boolean bl = shouldRender = renderType == null || renderType == DecoratorRenderType.CUTOUT;
            if (((Boolean)ModClientConfig.INSTANCE.RENDER.framedDrawers.renderTranslucentMaterials.get()).booleanValue()) {
                boolean bl2 = shouldRender = shouldRender || renderType == DecoratorRenderType.TRANSLUCENT;
            }
            if (shouldRender) {
                this.emitFramedQuads(context, emitModel, renderType);
            }
            if (this.shaded && (renderType == null || renderType == DecoratorRenderType.TRANSLUCENT)) {
                this.emitFramedOverlayQuads(context, emitModel, renderType);
            }
        }
    }

    @Override
    public void emitItemQuads(Supplier<C> contextSupplier, Consumer<BlockStateModel> emitModel, ItemStack stack, DecoratorRenderType renderType) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return;
        }
        MaterialData matData = context.materialData();
        if (matData != null && !matData.getEffectiveSide().isEmpty()) {
            boolean shouldRender;
            boolean bl = shouldRender = renderType == null || renderType == DecoratorRenderType.CUTOUT;
            if (((Boolean)ModClientConfig.INSTANCE.RENDER.framedDrawers.renderTranslucentMaterials.get()).booleanValue()) {
                boolean bl2 = shouldRender = shouldRender || renderType == DecoratorRenderType.TRANSLUCENT;
            }
            if (shouldRender) {
                this.emitFramedQuads(context, emitModel, renderType);
            }
            if (this.shaded && (renderType == null || renderType == DecoratorRenderType.TRANSLUCENT)) {
                this.emitFramedOverlayQuads(context, emitModel, renderType);
            }
        }
    }

    private BlockStateModel getReplacementModel(BlockStateModel baseModel, ItemStack material, DecoratorRenderType renderType) {
        Map<Object, Object> matCache;
        if (replacementCache.containsKey(baseModel)) {
            matCache = replacementCache.get(baseModel);
        } else {
            matCache = new HashMap();
            replacementCache.put(baseModel, matCache);
        }
        ResourceLocation matName = BuiltInRegistries.ITEM.getKey((Object)material.getItem());
        BlockStateModel replacedModel = null;
        if (matCache.containsKey(matName)) {
            replacedModel = (BlockStateModel)matCache.get(matName);
        } else {
            ChunkSectionLayer layer = ChunkSectionLayer.SOLID;
            if (renderType == DecoratorRenderType.CUTOUT) {
                layer = ChunkSectionLayer.CUTOUT;
            } else if (renderType == DecoratorRenderType.TRANSLUCENT) {
                layer = ChunkSectionLayer.TRANSLUCENT;
            }
            replacedModel = new SpriteReplacementModel(baseModel, material, layer);
            matCache.put(matName, replacedModel);
        }
        return replacedModel;
    }

    public void emitFramedQuads(FramedModelContext context, Consumer<BlockStateModel> emitModel, DecoratorRenderType renderType) {
        boolean opaquePass;
        Block block = context.state().getBlock();
        boolean renderTrans = (Boolean)ModClientConfig.INSTANCE.RENDER.framedDrawers.renderTranslucentMaterials.get();
        boolean checkOpaque = renderTrans && renderType != null;
        boolean bl = opaquePass = renderType == DecoratorRenderType.CUTOUT;
        if (block instanceof IFramedBlock) {
            IFramedBlock fb = (IFramedBlock)block;
            MaterialData matData = context.materialData();
            if (matData != null && !matData.isEmpty()) {
                BiConsumer<ItemStack, DrawerModelStore.DynamicPart> emitPart = (item, part) -> {
                    DecoratorRenderType render;
                    boolean opaque = matData.isMatOpaque((ItemStack)item);
                    DecoratorRenderType decoratorRenderType = render = !renderTrans || opaque ? DecoratorRenderType.CUTOUT : DecoratorRenderType.TRANSLUCENT;
                    if (!checkOpaque || opaquePass == opaque) {
                        BlockStateModel storeModel = this.getStoreModel(context, (DrawerModelStore.DynamicPart)((Object)part), render == DecoratorRenderType.TRANSLUCENT);
                        emitModel.accept(this.getReplacementModel(storeModel, (ItemStack)item, render));
                    }
                };
                if (this.matSet.sidePart() != null && fb.supportsFrameMaterial(FrameMaterial.SIDE)) {
                    emitPart.accept(matData.getEffectiveSide(), this.matSet.sidePart());
                }
                if (this.matSet.trimPart() != null && fb.supportsFrameMaterial(FrameMaterial.TRIM)) {
                    emitPart.accept(matData.getEffectiveTrim(), this.matSet.trimPart());
                }
                if (this.matSet.frontPart() != null && fb.supportsFrameMaterial(FrameMaterial.FRONT)) {
                    emitPart.accept(matData.getEffectiveFront(), this.matSet.frontPart());
                }
            }
        }
    }

    public void emitFramedOverlayQuads(FramedModelContext context, Consumer<BlockStateModel> emitModel, DecoratorRenderType renderType) {
        MaterialData matData = context.materialData();
        if (matData != null && !matData.isEmpty()) {
            if (this.matSet.shadeFrontPart() != null) {
                emitModel.accept(this.getStoreModel(context, this.matSet.shadeFrontPart()));
            }
            if (this.matSet.shadeSidePart() != null) {
                emitModel.accept(this.getStoreModel(context, this.matSet.shadeSidePart()));
            }
        }
    }

    protected abstract BlockStateModel getStoreModel(FramedModelContext var1, DrawerModelStore.DynamicPart var2);

    protected BlockStateModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part, boolean trans) {
        return this.getStoreModel(context, part);
    }

    public static class FacingSizedOpen<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSizedOpen(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BlockStateModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().getValue((Property)BlockDrawers.FACING);
            boolean half = false;
            EnumCompDrawer open = EnumCompDrawer.OPEN1;
            Block block = context.state().getBlock();
            if (block instanceof BlockCompDrawers) {
                BlockCompDrawers drawers = (BlockCompDrawers)block;
                half = drawers.isHalfDepth();
                open = (EnumCompDrawer)((Object)context.state().getValue(BlockCompDrawers.SLOTS));
            }
            return DrawerModelStore.getModel(part, dir, half, open);
        }
    }

    public static class FacingSizedSlotted<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSizedSlotted(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BlockStateModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().getValue((Property)BlockDrawers.FACING);
            boolean half = false;
            int count = 1;
            Block block = context.state().getBlock();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
                count = drawers.getDrawerCount();
            }
            return DrawerModelStore.getModel(part, dir, half, count);
        }
    }

    public static class FacingSized<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSized(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BlockStateModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().getValue((Property)BlockDrawers.FACING);
            boolean half = false;
            Block block = context.state().getBlock();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
            }
            return DrawerModelStore.getModel(part, dir, half);
        }
    }

    public static class Facing<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public Facing(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BlockStateModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            Direction dir = (Direction)context.state().getValue((Property)BlockDrawers.FACING);
            return DrawerModelStore.getModel(part, dir);
        }
    }

    public static class Single<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public Single(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected BlockStateModel getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            return DrawerModelStore.getModel(part);
        }
    }
}

