/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.state.DrawersRenderState;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BlockEntityDrawersRenderer
implements BlockEntityRenderer<BlockEntityDrawers, DrawersRenderState> {
    private final BlockEntityRendererProvider.Context context;
    private static final int TEXT_COLOR_TRANSPARENT = ARGB.color((int)0, (int)255, (int)255, (int)255);
    private static final Matrix3f ITEM_LIGHT_ROTATION_3D = new Matrix3f().rotationYXZ(0.36f, -0.36f, -0.014f);
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final ResourceLocation TEXTURE_IND_1 = ModConstants.loc("block/indicator/indicator_1_on");
    public static final ResourceLocation TEXTURE_IND_2 = ModConstants.loc("block/indicator/indicator_2_on");
    public static final ResourceLocation TEXTURE_IND_4 = ModConstants.loc("block/indicator/indicator_4_on");
    public static final ResourceLocation TEXTURE_IND_COMP_3 = ModConstants.loc("block/indicator/indicator_comp_on");
    public static final ResourceLocation TEXTURE_IND_COMP_2 = ModConstants.loc("block/indicator/indicator_comp2_on");

    public BlockEntityDrawersRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public DrawersRenderState createRenderState() {
        return new DrawersRenderState();
    }

    public void extractRenderState(BlockEntityDrawers blockEntity, DrawersRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumbleOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumbleOverlay);
        renderState.cameraPos = cameraPos;
        renderState.enforcedLightLevel = blockEntity.upgrades().hasIlluminationUpgrade() ? (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.illuminationLevel.get() : (Integer)ModCommonConfig.INSTANCE.UPGRADES.illuminationUpgrade.minIlluminationLevel.get();
        int blockLight = Math.max(renderState.lightCoords % 65536, renderState.enforcedLightLevel * 16);
        renderState.lightCoords = renderState.lightCoords & 0xFFFF0000 | blockLight;
        IDrawerAttributes attr = blockEntity.getDrawerAttributes();
        renderState.isConcealed = attr.isConcealed();
        renderState.showCount = attr.isShowingQuantity();
        renderState.showFill = attr.hasFillLevel();
        int longPos = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<DrawersRenderState.SlotState>();
        IDrawerGroup group = blockEntity.getGroup();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            ItemStackRenderState itemState = new ItemStackRenderState();
            this.context.itemModelResolver().updateForTopItem(itemState, drawer.getStoredItemPrototype(), ItemDisplayContext.GUI, blockEntity.getLevel(), null, longPos + i);
            renderState.items.add(new DrawersRenderState.SlotState(itemState, drawer.getStoredItemCount(), drawer.getMaxCapacity()));
        }
    }

    public void submit(DrawersRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!(renderState.blockState.getBlock() instanceof BlockDrawers)) {
            return;
        }
        Direction side = (Direction)renderState.blockState.getValue((Property)BlockDrawers.FACING);
        if (this.playerBehindBlock(renderState.blockPos, side)) {
            return;
        }
        float distance = (float)Math.sqrt(renderState.blockPos.distToCenterSqr((Position)renderState.cameraPos));
        double renderDistance = (Double)ModClientConfig.INSTANCE.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        if (!renderState.isConcealed) {
            this.renderFastItemSet(renderState, poseStack, submitNodeCollector, cameraRenderState, distance);
        }
    }

    private boolean playerBehindBlock(BlockPos blockPos, Direction facing) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        BlockPos playerPos = player.blockPosition();
        return switch (facing) {
            case Direction.NORTH -> {
                if (playerPos.getZ() > blockPos.getZ()) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (playerPos.getZ() < blockPos.getZ()) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (playerPos.getX() > blockPos.getX()) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (playerPos.getX() < blockPos.getX()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void renderFastItemSet(DrawersRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, float distance) {
        int drawerCount = renderState.items.size();
        for (int i = 0; i < drawerCount; ++i) {
            this.renderFastItem(i, renderState, poseStack, submitNodeCollector, cameraRenderState);
        }
        if (renderState.showCount) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ModClientConfig.INSTANCE.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ModClientConfig.INSTANCE.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                for (int i = 0; i < drawerCount; ++i) {
                    String format = CountFormatter.format(this.context.font(), renderState.items.get(i).count());
                    this.renderText(i, format, renderState, poseStack, submitNodeCollector, cameraRenderState, alpha);
                }
            }
        }
    }

    private void renderText(int slot, String text, DrawersRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, float alpha) {
        DrawersRenderState.SlotState slotInfo = renderState.items.get(slot);
        ItemStackRenderState itemState = slotInfo.itemState();
        if (itemState == null || itemState.isEmpty()) {
            return;
        }
        if (text == null || text.isEmpty()) {
            return;
        }
        Font fontRenderer = this.context.font();
        Block block = renderState.blockState.getBlock();
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        BlockDrawers block2 = (BlockDrawers)block;
        AABB labelGeometry = block2.countGeometry[slot];
        int textWidth = fontRenderer.width(text);
        float x = (float)(labelGeometry.minX + labelGeometry.getXsize() / 2.0);
        float y = 16.0f - (float)labelGeometry.minY - (float)labelGeometry.getYsize();
        float z = (float)labelGeometry.minZ * 0.0625f - 0.01f;
        poseStack.pushPose();
        Direction side = (Direction)renderState.blockState.getValue((Property)BlockDrawers.FACING);
        this.alignRendering(poseStack, side);
        poseStack.translate(x / 16.0f, 1.0f - y / 16.0f, 1.0f - z);
        poseStack.scale(0.0078125f, -0.0078125f, 1.0f);
        int color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        submitNodeCollector.submitText(poseStack, (float)(-textWidth) / 2.0f, 0.0f, FormattedCharSequence.forward((String)text, (Style)Style.EMPTY), false, Font.DisplayMode.POLYGON_OFFSET, renderState.lightCoords, color, 0, 0);
        poseStack.popPose();
    }

    private void renderFastItem(int slot, DrawersRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        DrawersRenderState.SlotState slotInfo = renderState.items.get(slot);
        ItemStackRenderState itemState = slotInfo.itemState();
        if (itemState == null || itemState.isEmpty()) {
            return;
        }
        Block block = renderState.blockState.getBlock();
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        BlockDrawers block2 = (BlockDrawers)block;
        AABB labelGeometry = block2.labelGeometry[slot];
        float scaleX = (float)labelGeometry.getXsize() / 16.0f;
        float scaleY = (float)labelGeometry.getYsize() / 16.0f;
        float moveX = (float)labelGeometry.minX + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.maxY + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.minZ * 0.0625f - 0.0025f;
        poseStack.pushPose();
        Direction side = (Direction)renderState.blockState.getValue((Property)BlockDrawers.FACING);
        this.alignRendering(poseStack, side);
        poseStack.translate(moveX / 16.0f, 1.0f - moveY / 16.0f, 1.0f - moveZ);
        poseStack.mulPose((Matrix4fc)new Matrix4f().scale(scaleX, scaleY, 0.001f));
        poseStack.last().trustedNormals = true;
        try {
            poseStack.last().normal().rotateYXZ(-this.getRotationYForSide2D(side), 0.0f, 0.0f).mul((Matrix3fc)ITEM_LIGHT_ROTATION_3D);
            itemState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.popPose();
    }

    private void alignRendering(PoseStack poseStack, Direction side) {
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Matrix4fc)new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }
}

