/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="storagedrawers")
public class PlayerEventListener {
    private static void applyDebuff(Player plr) {
        plr.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 3, true, true));
    }

    @SubscribeEvent
    public static void onPlayerPickup(EntityItemPickupEvent event) {
        if (!ModCommonConfig.INSTANCE.DRAWERS.anyHeavyDrawers()) {
            return;
        }
        PlayerEventListener.checkItemDebuf(event.getItem().getItem(), event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent.Post event) {
        if (event.player().tickCount % 60 != 0) {
            return;
        }
        if (event.side() == LogicalSide.SERVER) {
            ItemUpgradeRemote.validateInventory(event.player().getInventory(), event.player().level());
        }
        if (!ModCommonConfig.INSTANCE.DRAWERS.anyHeavyDrawers()) {
            return;
        }
        Inventory inv = event.player().getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (!PlayerEventListener.checkItemDebuf(inv.getItem(i), event.player())) continue;
            return;
        }
    }

    private static boolean checkItemDebuf(ItemStack stack, Player player) {
        IPortable ip;
        Item item = stack.getItem();
        if (item instanceof IPortable && (ip = (IPortable)item).isHeavy((HolderLookup.Provider)player.level().registryAccess(), stack)) {
            PlayerEventListener.applyDebuff(player);
            return true;
        }
        return false;
    }
}

