/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import org.jetbrains.annotations.NotNull;

public class ItemDrawers
extends BlockItem
implements IPortable {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, tooltip, flag);
        MutableComponent textCapacity = Component.translatable((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.accept((Component)Component.literal((String)"").append((Component)textCapacity).withStyle(ChatFormatting.GRAY));
        TypedEntityData blockData = (TypedEntityData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (blockData != null || customData != null) {
            MutableComponent textSealed = Component.translatable((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.accept((Component)Component.literal((String)"").append((Component)textSealed).withStyle(ChatFormatting.YELLOW));
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.heavyDrawers.get()).booleanValue() && this.isHeavy(context.registries(), stack)) {
            tooltip.accept((Component)Component.translatable((String)"tooltip.storagedrawers.drawers.too_heavy").withStyle(ChatFormatting.RED));
        }
    }

    public Component getName(ItemStack stack) {
        MutableComponent fallback = Component.empty();
        Block block = Block.byItem((Item)stack.getItem());
        if (block instanceof BlockStandardDrawers) {
            BlockStandardDrawers drawers = (BlockStandardDrawers)block;
            String matKey = drawers.getMatKey();
            if (matKey != null) {
                String mat = Component.translatable((String)drawers.getNameMatKey()).getString();
                fallback = Component.translatable((String)drawers.getNameTypeKey(), (Object[])new Object[]{mat});
            }
        } else {
            fallback = super.getName(stack);
        }
        return fallback;
    }

    @NotNull
    public Component getDescription() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc"));
    }

    @Override
    public boolean isHeavy(HolderLookup.Provider provider, @NotNull ItemStack stack) {
        if (stack.getItem() != this) {
            return false;
        }
        TypedEntityData data = (TypedEntityData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null) {
            return false;
        }
        UpgradeData x = new UpgradeData(7);
        try {
            x.read(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)provider, (CompoundTag)data.copyTagWithoutId()));
        }
        catch (ClassCastException e) {
            return false;
        }
        return !x.hasPortabilityUpgrade();
    }

    private int getCapacityForBlock(@NotNull ItemStack itemStack) {
        Block block = Block.byItem((Item)itemStack.getItem());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * ModCommonConfig.INSTANCE.DRAWERS.getBaseStackStorage();
        }
        return 0;
    }

    public boolean canFitInsideContainerItems() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.canStoreInContainers.get();
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        BlockDrawers bd;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof BlockDrawers && (bd = (BlockDrawers)block).retrimType() != null;
    }
}

