/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class BaseBlockEntity
extends BlockEntity {
    private CompoundTag failureSnapshot;
    private List<BlockEntityDataShim> fixedShims;
    private List<BlockEntityDataShim> portableShims;

    public BaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(BlockEntityDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<BlockEntityDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(BlockEntityDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<BlockEntityDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.readFixed(input);
        this.readPortable(input);
        this.onLoadFinished();
        if (this.level != null && this.level.isClientSide() && this.dataPacketRequiresRenderUpdate()) {
            this.markBlockForRenderUpdate();
        }
    }

    protected void onLoadFinished() {
    }

    public final void read(ValueInput input) {
        this.loadAdditional(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeFixed(output);
        this.writePortable(output);
    }

    public void readPortable(ValueInput input) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                shim.read(input);
            }
        }
    }

    public void writePortable(ValueOutput output) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                shim.write(output);
            }
        }
    }

    protected void readFixed(ValueInput input) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                shim.read(input);
            }
        }
    }

    protected void writeFixed(ValueOutput output) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                shim.write(output);
            }
        }
    }

    private void trapLoadFailure(Throwable t, CompoundTag tag) {
        this.failureSnapshot = tag.copy();
    }

    private void restoreLoadFailure(CompoundTag tag) {
        for (String key : this.failureSnapshot.keySet()) {
            if (tag.contains(key)) continue;
            tag.put(key, this.failureSnapshot.get(key).copy());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    @NotNull
    public final CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return this.hasDataPacket() ? ClientboundBlockEntityDataPacket.create((BlockEntity)this) : null;
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        if (pkt != null) {
            this.read(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)lookupProvider, (CompoundTag)pkt.getTag()));
        }
        if (this.getLevel() != null && this.getLevel().isClientSide() && this.dataPacketRequiresRenderUpdate()) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.getLevel() != null && !this.getLevel().isClientSide()) {
            BlockState state = this.getLevel().getBlockState(this.worldPosition);
            this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.getLevel() != null && this.getLevel().isClientSide()) {
            BlockState state = this.getLevel().getBlockState(this.worldPosition);
            this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.getLevel() == null) {
            return;
        }
        BlockState state = this.getLevel().getBlockState(this.worldPosition);
        this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 2);
    }
}

