/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.config.ConfigSpec;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;

public class ModClientConfig
extends ConfigSpec {
    public static ModClientConfig INSTANCE = new ModClientConfig();
    private final ChameleonConfig commonConfig = ChameleonServices.CONFIG.create(this);
    public General GENERAL;
    public Integration INTEGRATION;
    public Render RENDER;

    private ModClientConfig() {
    }

    public ChameleonConfig context() {
        return this.commonConfig;
    }

    @Override
    public void init() {
        this.GENERAL = new General(this);
        this.INTEGRATION = new Integration(this);
        this.RENDER = new Render();
    }

    public class General {
        public final ChameleonConfig.ConfigEntry<Boolean> invertShift;
        public final ChameleonConfig.ConfigEntry<Boolean> invertClick;

        public General(ModClientConfig this$0) {
            this$0.commonConfig.pushGroup("General");
            this.invertShift = this$0.commonConfig.define("invertShift", false).comment("Invert the behavior of the shift key for extracting items").build();
            this.invertClick = this$0.commonConfig.define("invertClick", false).comment("Invert left and right click action on drawers").build();
            this$0.commonConfig.popGroup();
        }
    }

    public class Integration {
        public final ChameleonConfig.ConfigEntry<Boolean> enableWaila;
        public final ChameleonConfig.ConfigEntry<Boolean> enableTheOneProbe;

        public Integration(ModClientConfig this$0) {
            this$0.commonConfig.pushGroup("Integration");
            this.enableWaila = this$0.commonConfig.define("enableWaila", true).comment("Enable extended data display in WAILA if present").build();
            this.enableTheOneProbe = this$0.commonConfig.define("enableTheOneProbe", true).comment("Enable extended data display in The One Probe if present").build();
            this$0.commonConfig.popGroup();
        }
    }

    public class Render {
        public final ChameleonConfig.ConfigEntry<Double> labelRenderDistance;
        public final ChameleonConfig.ConfigEntry<Double> quantityRenderDistance;
        public final ChameleonConfig.ConfigEntry<Double> quantityFadeDistance;
        public final FramedDrawers framedDrawers;

        public Render() {
            ModClientConfig.this.commonConfig.pushGroup("Render");
            this.labelRenderDistance = ModClientConfig.this.commonConfig.define("labelRenderDistance", 20.0).comment("Distance in blocks before item labels stop rendering").build();
            this.quantityRenderDistance = ModClientConfig.this.commonConfig.define("quantityRenderDistance", 10.0).comment("", "Distance in blocks before quantity numbers stop rendering").build();
            this.quantityFadeDistance = ModClientConfig.this.commonConfig.define("quantityFadeDistance", 20.0).comment("", "Distance in blocks before quantity numbers begin to fade out").build();
            this.framedDrawers = new FramedDrawers(this, "FramedDrawers", "Render settings specific to framed drawers.").build();
            ModClientConfig.this.commonConfig.popGroup();
        }

        public class FramedDrawers
        extends ConfigSection {
            public ChameleonConfig.ConfigEntry<Boolean> renderTranslucentMaterials;

            public FramedDrawers(Render this$1, String name, String ... comment) {
                super(name, comment);
                this.renderTranslucentMaterials = this$1.ModClientConfig.this.commonConfig.define("renderTranslucentMaterials", true).comment("", "Attempts to render 'non-opaque' materials on the translucent render pass.", "This may cause artifacting, particularly if using non-opaque materials on the 'front' face.");
            }

            @Override
            protected void buildEntries() {
                super.buildEntries();
                this.renderTranslucentMaterials.build();
            }

            @Override
            public FramedDrawers build() {
                super.build();
                return this;
            }
        }
    }

    class ConfigSection {
        protected final String name;
        protected final String[] comment;

        public ConfigSection(String name, String ... comment) {
            this.name = name;
            this.comment = comment;
        }

        public ConfigSection build() {
            if (this.comment != null && this.comment.length > 0) {
                ModClientConfig.this.commonConfig.comment(this.comment);
            }
            ModClientConfig.this.commonConfig.pushGroup(this.name);
            this.buildEntries();
            ModClientConfig.this.commonConfig.popGroup();
            return this;
        }

        protected void buildEntries() {
        }
    }
}

