/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemPriorityKey
extends ItemKey {
    private final int level;
    private final int nextLevel;
    private static final Map<Integer, ItemPriorityKey> priorityLookup = new HashMap<Integer, ItemPriorityKey>();

    public ItemPriorityKey(int level, int nextLevel, Item.Properties properties) {
        super(properties);
        this.level = level;
        this.nextLevel = nextLevel;
        priorityLookup.put(level, this);
    }

    public ItemPriorityKey getNextKey() {
        return priorityLookup.getOrDefault(this.nextLevel, this);
    }

    @Override
    protected void handleDrawerAttributes(IDrawerAttributesModifiable attrs) {
        if (this.level == 0) {
            attrs.setPriority(ItemPriorityKey.priorityLookup.getOrDefault((Object)Integer.valueOf((int)attrs.getPriority()), (ItemPriorityKey)this).getNextKey().level);
        } else if (this.level == attrs.getPriority()) {
            attrs.setPriority(0);
        } else {
            attrs.setPriority(this.level);
        }
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.priorityKey.enable.get()).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        ItemStack nextKey = new ItemStack((ItemLike)this.getNextKey(), 1);
        nextKey.set(DataComponents.CUSTOM_DATA, (Object)((CustomData)stack.get(DataComponents.CUSTOM_DATA)));
        return InteractionResult.SUCCESS.heldItemTransformedTo(nextKey);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)ModCommonConfig.INSTANCE.TOOLS.priorityKey.enable.get();
    }
}

