/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeMagnet;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.NotNull;

public class ItemUpgradeMagnet
extends ItemUpgrade {
    private static final int magnetGroupId = ItemUpgrade.getNextGroupId();
    public final EnumUpgradeMagnet type;

    public ItemUpgradeMagnet(EnumUpgradeMagnet type, Item.Properties properties) {
        this(type, properties, magnetGroupId);
    }

    protected ItemUpgradeMagnet(EnumUpgradeMagnet type, Item.Properties properties, int groupId) {
        super(properties, groupId);
        this.setAllowMultiple(true);
        this.type = type;
    }

    @Override
    @NotNull
    public Component getDescription() {
        if (!this.isEnabled()) {
            return super.getDescription();
        }
        return Component.translatable((String)"item.storagedrawers.magnet_upgrade.desc");
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, tooltip, flag);
        if (!this.isEnabled()) {
            return;
        }
        String rangeId = ((Item)ModItems.MAGNET_UPGRADE.get()).getDescriptionId() + ".range";
        tooltip.accept((Component)Component.translatable((String)rangeId, (Object[])new Object[]{this.buildRangeString()}).withStyle(ChatFormatting.DARK_GRAY));
        String rateId = ((Item)ModItems.MAGNET_UPGRADE.get()).getDescriptionId() + ".speed";
        int activeSpeed = this.getActiveSpeed();
        tooltip.accept((Component)Component.translatable((String)rateId, (Object[])new Object[]{1, activeSpeed}).withStyle(ChatFormatting.DARK_GRAY));
    }

    private String buildRangeString() {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        int hRange = this.getHorzRange();
        int upRange = this.getUpRange();
        int downRange = this.getDownRange();
        if (hRange == upRange && hRange == downRange) {
            return Integer.toString(hRange);
        }
        if (hRange > 0) {
            result.add((CallSite)((Object)(hRange + "\u2194")));
        }
        if (upRange > 0) {
            result.add((CallSite)((Object)(upRange + "\u2191")));
        }
        if (downRange > 0) {
            result.add((CallSite)((Object)(downRange + "\u2193")));
        }
        return String.join((CharSequence)", ", result);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getConfig().enableUpgrade.get();
    }

    public int getActiveSpeed() {
        return (Integer)this.getConfig().activeSpeed.get();
    }

    public int getIdleSpeed() {
        return (Integer)this.getConfig().idleSpeed.get();
    }

    public int getHorzRange() {
        return this.getIndexedRange(0);
    }

    public int getUpRange() {
        return this.getIndexedRange(1);
    }

    public int getDownRange() {
        return this.getIndexedRange(2);
    }

    private int getIndexedRange(int index) {
        return (Integer)((List)this.getConfig().range.get()).get(index);
    }

    private ModCommonConfig.Upgrades.MagnetTierUpgrade getConfig() {
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case EnumUpgradeMagnet.LEVEL1 -> ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.tier1;
            case EnumUpgradeMagnet.LEVEL2 -> ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.tier2;
            case EnumUpgradeMagnet.LEVEL3 -> ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.tier3;
        };
    }
}

