/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.modelprops;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DrawerModelProperties
implements ModelContextSupplier<DrawerModelContext> {
    public static final DrawerModelProperties INSTANCE = new DrawerModelProperties();
    public final IDrawerAttributes attributes;
    public final IDrawerGroup group;
    public final IProtectable protectable;
    public final MaterialData material;

    protected DrawerModelProperties() {
        this.attributes = null;
        this.group = null;
        this.protectable = null;
        this.material = null;
    }

    protected DrawerModelProperties(BlockEntityDrawers blockEntity) {
        this.attributes = blockEntity.getDrawerAttributes();
        this.group = blockEntity.getGroup();
        this.protectable = blockEntity;
        this.material = blockEntity.material();
    }

    public static DrawerModelProperties getModelData(BlockEntityDrawers blockEntity) {
        return new DrawerModelProperties(blockEntity);
    }

    @Override
    public DrawerModelContext makeContext(@Nullable BlockState state, RandomSource rand, Object renderData) {
        if (renderData instanceof DrawerModelProperties) {
            DrawerModelProperties props = (DrawerModelProperties)renderData;
            return new DrawerModelContext(state, rand).attr(props.attributes).group(props.group).protectable(props.protectable).materialData(props.material);
        }
        return new DrawerModelContext(state, rand);
    }

    @Override
    public DrawerModelContext makeContext(ItemStack stack) {
        MaterialData data = ((FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY)).asMaterialData();
        Block block = Blocks.AIR;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        }
        return new DrawerModelContext(block.defaultBlockState()).materialData(data);
    }
}

