/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ControllerData
extends BlockEntityDataShim {
    private BlockPos controllerCoord;

    @Override
    public void read(ValueInput input) {
        this.controllerCoord = null;
        input.child("Controller").ifPresent(t -> {
            this.controllerCoord = new BlockPos(t.getIntOr("x", 0), t.getIntOr("y", 0), t.getIntOr("z", 0));
        });
    }

    @Override
    public void write(ValueOutput output) {
        if (this.controllerCoord != null) {
            ValueOutput ctag = output.child("Controller");
            ctag.putInt("x", this.controllerCoord.getX());
            ctag.putInt("y", this.controllerCoord.getY());
            ctag.putInt("z", this.controllerCoord.getZ());
        }
    }

    public BlockPos getCoord() {
        return this.controllerCoord;
    }

    public BlockEntityController getController(BlockEntity host) {
        if (this.controllerCoord == null) {
            return null;
        }
        if (host.getLevel() == null) {
            return null;
        }
        BlockEntity blockEntity = host.getLevel().getBlockEntity(this.controllerCoord);
        if (!(blockEntity instanceof BlockEntityController)) {
            this.controllerCoord = null;
            host.setChanged();
            return null;
        }
        return (BlockEntityController)blockEntity;
    }

    public boolean bind(BlockEntityController entity) {
        return this.bindCoord(entity != null ? entity.getBlockPos() : null);
    }

    public boolean bindCoord(BlockPos pos) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("ControllerData [{}] bind coord [{}]", (Object)this.controllerCoord, (Object)pos);
        }
        if (this.controllerCoord == null || !this.controllerCoord.equals((Object)pos)) {
            this.controllerCoord = pos;
            return true;
        }
        return false;
    }
}

