/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp3;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.storage.StorageUtil;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityDrawers
extends BaseBlockEntity
implements IDrawerGroup,
IProtectable,
INetworked,
IFramedBlockEntity,
Nameable {
    private MaterialData materialData = new MaterialData();
    private final UpgradeData upgradeData = new DrawerUpgradeData();
    private final ControllerData controllerData = new ControllerData();
    private UUID owner;
    private String securityKey;
    private Component name;
    protected final IDrawerAttributesModifiable drawerAttributes = new DrawerAttributes();
    private long lastClickTime;
    private UUID lastClickUUID;
    private boolean loading;

    protected BlockEntityDrawers(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.upgradeData.setDrawerAttributes(this.drawerAttributes);
        this.injectPortableData(this.upgradeData);
        this.injectPortableData(this.controllerData);
        this.injectData(this.materialData);
    }

    private void checkBoundController() {
        Item item;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("BlockEntityDrawers [{}] checkBoundController", (Object)this.getBlockPos());
        }
        BlockEntityController controller = this.controllerData.getController(this);
        ItemStack remote = this.upgradeData.getRemoteUpgrade();
        if (remote == null && controller != null) {
            controller.invalidateRemoteNode(this);
            this.controllerData.bind(null);
            return;
        }
        if (remote != null && (item = remote.getItem()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote itemRemote = (ItemUpgradeRemote)item;
            BlockEntityController upgradeController = ItemUpgradeRemote.getBoundController(remote, (LevelAccessor)this.level);
            if (controller != null && controller != upgradeController) {
                controller.invalidateRemoteNode(this);
            }
            if (upgradeController != null) {
                this.controllerData.bind(upgradeController);
                if (!upgradeController.addRemoteNode(this)) {
                    this.controllerData.bind(null);
                }
            }
            if (itemRemote.isBound() && this.controllerData.getController(this) == null) {
                this.upgradeData.unbindRemoteUpgrade();
            }
        }
    }

    public void validateBoundController() {
        this.checkBoundController();
    }

    @Override
    public boolean supportsDirectControllerLink() {
        return true;
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        return this.controllerData.getController(this);
    }

    @Override
    public boolean canRecurseSearch() {
        ItemStack upgrade = this.upgradeData.getRemoteUpgrade();
        if (upgrade == null) {
            return true;
        }
        Item item = upgrade.getItem();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            return item2.isGroupUpgrade();
        }
        return true;
    }

    @Override
    public void unbindControlGroup() {
        this.upgradeData.unbindRemoteUpgrade();
    }

    @NotNull
    public abstract IDrawerGroup getGroup();

    public static IDrawerGroup getGroup(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getGroup();
    }

    @NotNull
    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public static IDrawerAttributes getDrawerAttributes(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getDrawerAttributes();
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    @Override
    public boolean isGroupValid() {
        return !this.isRemoved();
    }

    public int getDrawerCapacity() {
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        return ((BlockDrawers)block).getStorageUnits();
    }

    public int getEffectiveDrawerCapacity() {
        if (this.upgradeData.hasOneStackUpgrade()) {
            return 1;
        }
        return this.getDrawerCapacity() * (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get();
    }

    protected boolean emptySlotCanBeCleared(int slot) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        return !drawer.isEmpty() && drawer.getStoredItemCount() == 0;
    }

    @Override
    public UUID getOwner() {
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.level != null && !this.level.isClientSide) {
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return ModSecurity.registry.getProvider(this.securityKey);
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.level != null && !this.level.isClientSide) {
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    protected void onAttributeChanged() {
    }

    public boolean isRedstone() {
        return this.upgradeData.getRedstoneType() != null;
    }

    public int getRedstoneLevel() {
        EnumUpgradeRedstone type = this.upgradeData.getRedstoneType();
        if (type == null) {
            return 0;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EnumUpgradeRedstone.COMBINED -> this.getCombinedRedstoneLevel();
            case EnumUpgradeRedstone.MAX -> this.getMaxRedstoneLevel();
            case EnumUpgradeRedstone.MIN -> this.getMinRedstoneLevel();
        };
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled() || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @NotNull
    public ItemStack takeItemsFromSlot(int slot, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled() || drawer.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = drawer.getStoredItemPrototype().copy();
        stack.setCount(Math.min(count, drawer.getStoredItemCount()));
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.getCount());
        if (this.upgradeData.hasbalancedFillUpgrade() && !this.upgradeData.hasVendingUpgrade()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        if (this.isRedstone() && this.getLevel() != null) {
            this.getLevel().updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.getLevel().updateNeighborsAt(this.getBlockPos().below(), this.getBlockState().getBlock());
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, @NotNull ItemStack stack, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (!drawer.canItemBeStoredManual(stack, null)) {
            return 0;
        }
        if (drawer.isEmpty()) {
            drawer = drawer.setStoredItem(stack);
        }
        int countAdded = Math.min(count, stack.getCount());
        if (!this.drawerAttributes.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.shrink(countAdded);
        if (this.upgradeData.hasbalancedFillUpgrade() && !this.upgradeData.hasVendingUpgrade()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        return countAdded;
    }

    public int interactPutCurrentItemIntoSlot(int slot, Player player) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        ItemStack playerStack = player.getInventory().getSelected();
        if (!playerStack.isEmpty()) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.getCount());
        }
        return count;
    }

    public int interactPutCurrentInventoryIntoSlot(int slot, Player player) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        if (!drawer.isEmpty()) {
            int n = player.getInventory().getContainerSize();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.getInventory().getItem(i);
                if (subStack.isEmpty()) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.getCount());
                if (subCount > 0 && subStack.getCount() == 0) {
                    player.getInventory().setItem(i, ItemStack.EMPTY);
                }
                count += subCount;
            }
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, Player player) {
        if (this.getLevel() == null) {
            return 0;
        }
        int count = this.getLevel().getGameTime() - this.lastClickTime < 10L && player.getUUID().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.getLevel().getGameTime();
        this.lastClickUUID = player.getUUID();
        return count;
    }

    public boolean interactReplaceDrawer(int slot, ItemStack detachedDrawer) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isMissing()) {
            return false;
        }
        if (detachedDrawer.isEmpty()) {
            return false;
        }
        CustomData customdata = (CustomData)detachedDrawer.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = customdata != null ? customdata.copyTag() : new CompoundTag();
        DetachedDrawerData data = new DetachedDrawerData((HolderLookup.Provider)this.level.registryAccess(), tag);
        ItemStack proto = data.getStoredItemPrototype();
        int count = data.getStoredItemCount();
        if (count > drawer.getMaxCapacity(proto)) {
            return false;
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get()).booleanValue()) {
            int cap = this.getEffectiveDrawerCapacity() * this.upgradeData.getStorageMultiplier();
            if (data.getStorageMultiplier() < cap) {
                return false;
            }
        }
        drawer.setDetached(false);
        drawer.setStoredItem(proto, count);
        if (this.drawerAttributes.isBalancedFill()) {
            StorageUtil.rebalanceDrawers(this.getGroup(), slot);
        }
        return true;
    }

    @Override
    public void readPortable(HolderLookup.Provider provider, CompoundTag tag) {
        this.loading = true;
        super.readPortable(provider, tag);
        if (tag.contains("Lock")) {
            EnumSet<LockAttribute> attrs = LockAttribute.getEnumSet(tag.getByte("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains((Object)LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains((Object)LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (tag.contains("Shr")) {
            this.drawerAttributes.setIsConcealed(tag.getBoolean("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (tag.contains("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(tag.getBoolean("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
        this.owner = null;
        if (tag.contains("Own")) {
            this.owner = UUID.fromString(tag.getString("Own"));
        }
        this.securityKey = null;
        if (tag.contains("Sec")) {
            this.securityKey = tag.getString("Sec");
        }
        if (tag.contains("Pri")) {
            this.drawerAttributes.setPriority(tag.getInt("Pri"));
        } else {
            this.drawerAttributes.setPriority(0);
        }
        if (tag.contains("CustomName", 8)) {
            this.name = BlockEntityDrawers.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        this.loading = false;
    }

    @Override
    public CompoundTag writePortable(HolderLookup.Provider provider, CompoundTag tag) {
        tag = super.writePortable(provider, tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.putByte("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.putBoolean("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.putBoolean("Qua", true);
        }
        if (this.owner != null) {
            tag.putString("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.putString("Sec", this.securityKey);
        }
        if (this.drawerAttributes.getPriority() != 0) {
            tag.putInt("Pri", this.drawerAttributes.getPriority());
        }
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
        return tag;
    }

    public void setChanged() {
        if (this.isRedstone() && this.getLevel() != null) {
            this.getLevel().updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.getLevel().updateNeighborsAt(this.getBlockPos().below(), this.getBlockState().getBlock());
        }
        super.setChanged();
    }

    protected void syncClientCount(int slot, int count) {
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            return;
        }
        ChameleonServices.NETWORK.sendToPlayersNear(new CountUpdateMessage(this.getBlockPos(), slot, count), (ServerLevel)this.getLevel(), this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ(), 500.0);
    }

    public void clientUpdateCount(int slot, int count) {
        if (this.getLevel() == null || !this.getLevel().isClientSide) {
            return;
        }
        Minecraft.getInstance().tell(() -> this.clientUpdateCountAsync(slot, count));
    }

    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @Deprecated
    public int getDrawerCount() {
        return this.getGroup().getDrawerCount();
    }

    @Override
    @Deprecated
    @NotNull
    public IDrawer getDrawer(int slot) {
        return this.getGroup().getDrawer(slot);
    }

    @Override
    @Deprecated
    public int[] getAccessibleDrawerSlots() {
        return this.getGroup().getAccessibleDrawerSlots();
    }

    public Component getName() {
        if (this.name != null) {
            return this.name;
        }
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        return stack.getItem().getName(stack);
    }

    public Component getCustomName() {
        return this.name;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.name = (Component)input.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.level == null) {
            return null;
        }
        return capability.getCapability(this.level, this.getBlockPos());
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        @Override
        public boolean canAddUpgrade(@NotNull ItemStack upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.getItem() == ModItems.ONE_STACK_UPGRADE.get()) {
                int lostStackCapacity = BlockEntityDrawers.this.upgradeData.getStorageMultiplier() * (BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1);
                return this.stackCapacityCheck(lostStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.getItem() instanceof ItemUpgradeStorage) {
                int storageLevel = ((ItemUpgradeStorage)upgrade.getItem()).level.getLevel();
                int storageMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageLevel);
                int effectiveStorageMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                int addedStackCapacity = storageMult * BlockEntityDrawers.this.getEffectiveDrawerCapacity();
                return this.stackCapacityCheck(addedStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canSwapUpgrade(int slot, @NotNull ItemStack add) {
            if (!(add.getItem() instanceof ItemUpgradeStorage)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.getItem() == ModItems.ONE_STACK_UPGRADE.get()) {
                return true;
            }
            if (!(upgrade.getItem() instanceof ItemUpgradeStorage)) {
                return false;
            }
            if (!this.canAddUpgrade(add)) {
                return false;
            }
            if (((ItemUpgradeStorage)add.getItem()).level.getLevel() > ((ItemUpgradeStorage)upgrade.getItem()).level.getLevel()) {
                return true;
            }
            int currentUpgradeMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
            int storageLevel = ((ItemUpgradeStorage)upgrade.getItem()).level.getLevel();
            int storageMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageLevel);
            int removedStacks = Math.min(currentUpgradeMult * BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1, currentUpgradeMult * (BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1) + storageMult);
            return this.stackCapacityCheck(removedStacks);
        }

        @Override
        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (BlockEntityDrawers.this.getLevel() != null && !BlockEntityDrawers.this.getLevel().isClientSide) {
                BlockEntityDrawers.this.checkBoundController();
                if (BlockEntityDrawers.this.getBoundControlGroup() != null) {
                    BlockEntityDrawers.this.getBoundControlGroup().addRemoteNode(BlockEntityDrawers.this);
                }
                BlockEntityDrawers.this.setChanged();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }

        private boolean stackCapacityCheck(int stackCapacity) {
            for (int i = 0; i < BlockEntityDrawers.this.getDrawerCount(); ++i) {
                IDrawer drawer = BlockEntityDrawers.this.getDrawer(i);
                if (!drawer.isEnabled() || drawer.isEmpty()) continue;
                int addedItemCapacity = stackCapacity * drawer.getStoredItemStackSize();
                if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
                return false;
            }
            return true;
        }
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        @Override
        protected void onAttributeChanged() {
            if (!BlockEntityDrawers.this.loading && !BlockEntityDrawers.this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                for (int slot = 0; slot < BlockEntityDrawers.this.getGroup().getDrawerCount(); ++slot) {
                    if (!BlockEntityDrawers.this.emptySlotCanBeCleared(slot)) continue;
                    IDrawer drawer = BlockEntityDrawers.this.getGroup().getDrawer(slot);
                    drawer.setStoredItem(ItemStack.EMPTY);
                }
            }
            BlockEntityDrawers.this.onAttributeChanged();
            if (BlockEntityDrawers.this.getLevel() != null && !BlockEntityDrawers.this.getLevel().isClientSide) {
                BlockEntityDrawers.this.setChanged();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityDrawers entity;

        public ContentProvider(BlockEntityDrawers entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(ServerPlayer player) {
            return new PositionContent(this.entity.getBlockPos());
        }

        public Component getDisplayName() {
            return this.entity.getDisplayName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return switch (this.entity.getGroup().getDrawerCount()) {
                case 1 -> new ContainerDrawers1(id, inventory, this.entity);
                case 2 -> new ContainerDrawers2(id, inventory, this.entity);
                case 4 -> new ContainerDrawers4(id, inventory, this.entity);
                case 3 -> new ContainerDrawersComp3(id, inventory, this.entity);
                default -> null;
            };
        }
    }
}

