/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.components.item.DetachedDrawerContents;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.DetachedDrawerTooltip;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ItemDetachedDrawer
extends Item
implements IPortable {
    public ItemDetachedDrawer(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)this);
        DetachedDrawerData data = new DetachedDrawerData();
        data.setStorageMultiplier((Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get() * 8);
        ItemStack savedItem = data.getStoredItemPrototype().copyWithCount(data.getStoredItemCount());
        DetachedDrawerContents contents = new DetachedDrawerContents(savedItem, data.getStorageMultiplier(), data.isHeavy());
        stack.set((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get(), (Object)contents);
        return stack;
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        ComponentUtil.appendSplitDescription(tooltip, this);
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.heavyDrawers.get()).booleanValue() && this.isHeavy(context.registries(), stack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.storagedrawers.drawers.too_heavy").withStyle(ChatFormatting.RED));
        }
    }

    public String getDescriptionId() {
        if (this == ModItems.DETACHED_DRAWER.get()) {
            return super.getDescriptionId();
        }
        return ((Item)ModItems.DETACHED_DRAWER.get()).getDescriptionId();
    }

    @NotNull
    public Component getDescription() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.enable.get() != false ? Component.translatable((String)(this.getDescriptionId() + ".desc")) : Component.translatable((String)"itemConfig.storagedrawers.disabled_tool").withStyle(ChatFormatting.RED);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(DataComponents.HIDE_TOOLTIP) || stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        if (!stack.has((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get())) {
            return Optional.empty();
        }
        return Optional.ofNullable((DetachedDrawerContents)stack.get((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get())).map(DetachedDrawerTooltip::new);
    }

    public boolean canFitInsideContainerItems() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.canStoreInContainers.get();
    }

    @Override
    public boolean isHeavy(HolderLookup.Provider provider, @NotNull ItemStack stack) {
        if (stack.getItem() != this) {
            return false;
        }
        CustomData cdata = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        DetachedDrawerData data = new DetachedDrawerData(provider, cdata.copyTag());
        return data.isHeavy() && data.getStoredItemCount() > data.getStoredItemStackSize();
    }
}

