/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MaterialData
extends BlockEntityDataShim
implements IFramedMaterials {
    public static final MaterialData EMPTY = new MaterialData();
    public static final Codec<MaterialData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("frameBase").forGetter(MaterialData::getFrameBase), (App)ItemStack.CODEC.fieldOf("materialSide").forGetter(MaterialData::getSide), (App)ItemStack.CODEC.fieldOf("materialFront").forGetter(MaterialData::getFront), (App)ItemStack.CODEC.fieldOf("materialTrim").forGetter(MaterialData::getTrim)).apply((Applicative)instance, MaterialData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MaterialData::getFrameBase, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MaterialData::getSide, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MaterialData::getFront, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MaterialData::getTrim, MaterialData::new);
    @NotNull
    private ItemStack frameBase;
    @NotNull
    private ItemStack materialSide;
    @NotNull
    private ItemStack materialFront;
    @NotNull
    private ItemStack materialTrim;

    public MaterialData() {
        this(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    public MaterialData(@NotNull ItemStack frameBase, @NotNull ItemStack side, @NotNull ItemStack front, @NotNull ItemStack trim) {
        this.frameBase = frameBase;
        this.materialSide = side;
        this.materialFront = front;
        this.materialTrim = trim;
    }

    public MaterialData(IFramedMaterials materials) {
        this();
        if (materials != null) {
            this.frameBase = materials.getHostBlock();
            this.materialSide = materials.getMaterial(FrameMaterial.SIDE);
            this.materialFront = materials.getMaterial(FrameMaterial.FRONT);
            this.materialTrim = materials.getMaterial(FrameMaterial.TRIM);
        }
    }

    @NotNull
    public ItemStack getFrameBase() {
        return this.frameBase;
    }

    @NotNull
    public ItemStack getSide() {
        return this.materialSide;
    }

    @NotNull
    public ItemStack getFront() {
        return this.materialFront;
    }

    @NotNull
    public ItemStack getTrim() {
        return this.materialTrim;
    }

    @NotNull
    public ItemStack getEffectiveSide() {
        return this.materialSide;
    }

    @NotNull
    public ItemStack getEffectiveFront() {
        return !this.materialFront.isEmpty() ? this.materialFront : this.materialSide;
    }

    @NotNull
    public ItemStack getEffectiveTrim() {
        return !this.materialTrim.isEmpty() ? this.materialTrim : this.materialSide;
    }

    public void setFrameBase(@NotNull ItemStack frameBase) {
        this.frameBase = frameBase;
    }

    public void setSide(@NotNull ItemStack material) {
        this.materialSide = material;
    }

    public void setFront(@NotNull ItemStack material) {
        this.materialFront = material;
    }

    public void setTrim(@NotNull ItemStack material) {
        this.materialTrim = material;
    }

    public void clear() {
        this.materialSide = ItemStack.EMPTY;
        this.materialFront = ItemStack.EMPTY;
        this.materialTrim = ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        return this.materialFront.isEmpty() && this.materialSide.isEmpty() && this.materialTrim.isEmpty();
    }

    public void read(ItemStack stack) {
        FrameData data = (FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
        this.frameBase = data.base();
        this.materialSide = data.side();
        this.materialFront = data.front();
        this.materialTrim = data.trim();
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.frameBase = ItemStack.EMPTY;
        if (tag.contains("MatB")) {
            this.frameBase = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("MatB"));
        }
        this.materialSide = ItemStack.EMPTY;
        if (tag.contains("MatS")) {
            this.materialSide = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("MatS"));
        }
        this.materialFront = ItemStack.EMPTY;
        if (tag.contains("MatF")) {
            this.materialFront = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("MatF"));
        }
        this.materialTrim = ItemStack.EMPTY;
        if (tag.contains("MatT")) {
            this.materialTrim = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("MatT"));
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        if (!this.frameBase.isEmpty()) {
            tag.put("MatB", this.frameBase.saveOptional(provider));
        } else if (tag.contains("MatB")) {
            tag.remove("MatB");
        }
        if (!this.materialSide.isEmpty()) {
            tag.put("MatS", this.materialSide.saveOptional(provider));
        } else if (tag.contains("MatS")) {
            tag.remove("MatS");
        }
        if (!this.materialFront.isEmpty()) {
            tag.put("MatF", this.materialFront.saveOptional(provider));
        } else if (tag.contains("MatF")) {
            tag.remove("MatF");
        }
        if (!this.materialTrim.isEmpty()) {
            tag.put("MatT", this.materialTrim.saveOptional(provider));
        } else if (tag.contains("MatT")) {
            tag.remove("MatT");
        }
        return tag;
    }

    @Override
    @NotNull
    public ItemStack getHostBlock() {
        return this.frameBase;
    }

    @Override
    public void setHostBlock(@NotNull ItemStack stack) {
        this.frameBase = stack;
    }

    @Override
    @NotNull
    public ItemStack getMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new MatchException(null, null);
            case FrameMaterial.SIDE -> this.materialSide;
            case FrameMaterial.TRIM -> this.materialTrim;
            case FrameMaterial.FRONT -> this.materialFront;
        };
    }

    @Override
    public void setMaterial(FrameMaterial material, @NotNull ItemStack stack) {
        switch (material) {
            case SIDE: {
                this.materialSide = stack;
                break;
            }
            case TRIM: {
                this.materialTrim = stack;
                break;
            }
            case FRONT: {
                this.materialFront = stack;
            }
        }
    }
}

