/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class StorageBlacklist {
    public static final StorageBlacklist INSTANCE = new StorageBlacklist();
    private final List<String> blacklistNamespaces = new ArrayList<String>();
    private final List<Item> blacklistItems = new ArrayList<Item>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        ModCommonConfig.INSTANCE.onLoad(() -> ((List)ModCommonConfig.INSTANCE.GENERAL.storeBlacklist.get()).forEach(this::register));
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    public boolean isBlacklisted(ItemStack stack) {
        String namespace;
        ResourceKey resourceKey;
        Item item = stack.getItem();
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableStoreFilledDrawers.get()).booleanValue() && (item instanceof ItemDrawers || item instanceof ItemDetachedDrawer)) {
            CustomData blockData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (blockData != null || customData != null) {
                return true;
            }
        }
        if (this.blacklistItems.contains(item)) {
            return true;
        }
        return !this.blacklistNamespaces.isEmpty() && (resourceKey = (ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)item).orElse(null)) != null && this.blacklistNamespaces.contains(namespace = resourceKey.location().getNamespace());
    }

    public boolean registerNamespace(@NotNull String namespace) {
        if (namespace.isEmpty()) {
            return false;
        }
        this.unregisterNamespace(namespace);
        this.blacklistNamespaces.add(namespace);
        ModServices.log.info("New blacklisted namespace " + namespace);
        return true;
    }

    public boolean registerItem(@NotNull ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        this.unregisterItem(item);
        this.blacklistItems.add(item.getItem());
        ModServices.log.info("New blacklisted item " + String.valueOf(item.getItem()));
        return true;
    }

    public void register(List<String> entries) {
        entries.forEach(this::register);
    }

    public boolean register(String entry) {
        if (!this.initialized) {
            this.pendingRules.add(entry);
            return true;
        }
        String[] parts = entry.split("\\s*:\\s*");
        if (parts.length == 1) {
            return this.registerNamespace(parts[0]);
        }
        ResourceLocation resource = ResourceLocation.parse((String)entry);
        Item item = (Item)BuiltInRegistries.ITEM.get(resource);
        return this.registerItem(new ItemStack((ItemLike)item));
    }

    public boolean unregisterNamespace(@NotNull String namespace) {
        if (namespace.isEmpty()) {
            return false;
        }
        return this.blacklistNamespaces.remove(namespace);
    }

    public boolean unregisterItem(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.blacklistItems.remove(stack.getItem());
    }
}

