/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotUpgrade
extends Slot {
    public SlotUpgrade(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Container container = this.container;
        if (container instanceof InventoryUpgrade) {
            InventoryUpgrade inventoryUpgrade = (InventoryUpgrade)container;
            if (this.getItem().isEmpty()) {
                return inventoryUpgrade.canAddUpgrade(stack);
            }
            return inventoryUpgrade.canSwapUpgrade(this.getContainerSlot(), stack);
        }
        return false;
    }

    public boolean mayPickup(@NotNull Player player) {
        return this.canTakeStack(player);
    }

    public boolean canTakeStack() {
        return this.canTakeStack(null);
    }

    public boolean canTakeStack(@Nullable Player player) {
        Container container = this.container;
        if (container instanceof InventoryUpgrade) {
            InventoryUpgrade inventoryUpgrade = (InventoryUpgrade)container;
            ItemStack stack = this.getItem();
            if (stack.getItem() instanceof ItemUpgradeStorage) {
                return inventoryUpgrade.canRemoveStorageUpgrade(this.getContainerSlot());
            }
            if (!inventoryUpgrade.canRemoveUpgrade(this.getContainerSlot())) {
                return false;
            }
            if (player != null && !player.isCreative()) {
                return stack.getItem() != ModItems.CREATIVE_STORAGE_UPGRADE.get() && stack.getItem() != ModItems.CREATIVE_VENDING_UPGRADE.get();
            }
        }
        return true;
    }

    public boolean canSwapStack(@NotNull ItemStack stack) {
        Container container = this.container;
        if (container instanceof InventoryUpgrade) {
            InventoryUpgrade invUpgrade = (InventoryUpgrade)container;
            return invUpgrade.canSwapUpgrade(this.getContainerSlot(), stack);
        }
        return false;
    }
}

