/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersStandard
extends BlockEntityDrawers {
    public BlockEntityDrawersStandard(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private final int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        private StandardDrawerData(StandardDrawerData data) {
            super(data);
            this.slot = data.slot;
        }

        @Override
        protected int getStackCapacity() {
            try {
                return Math.multiplyExact(BlockEntityDrawersStandard.this.upgrades().getStorageMultiplier(), BlockEntityDrawersStandard.this.getEffectiveDrawerCapacity());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        protected void onItemChanged() {
            if (BlockEntityDrawersStandard.this.getLevel() != null && !BlockEntityDrawersStandard.this.getLevel().isClientSide) {
                BlockEntityDrawersStandard.this.setChanged();
                BlockEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (BlockEntityDrawersStandard.this.getLevel() != null && !BlockEntityDrawersStandard.this.getLevel().isClientSide) {
                BlockEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                BlockEntityDrawersStandard.this.setChanged();
            }
        }

        @Override
        public IDrawer copy() {
            return new StandardDrawerData(this);
        }
    }

    private class GroupData
    extends StandardDrawerGroup
    implements IProtectable {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        @NotNull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersStandard.this.isGroupValid();
        }

        @Override
        public <T> T getCapability(ChameleonCapability<T> capability) {
            if (BlockEntityDrawersStandard.this.level == null) {
                return null;
            }
            return capability.getCapability(BlockEntityDrawersStandard.this.level, BlockEntityDrawersStandard.this.getBlockPos());
        }

        @Override
        public UUID getOwner() {
            return BlockEntityDrawersStandard.this.getOwner();
        }

        @Override
        public boolean setOwner(UUID owner) {
            return BlockEntityDrawersStandard.this.setOwner(owner);
        }

        @Override
        public ISecurityProvider getSecurityProvider() {
            return BlockEntityDrawersStandard.this.getSecurityProvider();
        }

        @Override
        public boolean setSecurityProvider(ISecurityProvider provder) {
            return BlockEntityDrawersStandard.this.setSecurityProvider(provder);
        }
    }

    public static class Slot4
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(4);

        public Slot4(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_4.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_2.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot1
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(1);

        public Slot1(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_1.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

