/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.modelprops;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class ForgeFramedModelProperties
extends FramedModelProperties {
    public static final ForgeFramedModelProperties INSTANCE = new ForgeFramedModelProperties();
    public static final ModelProperty<BlockState> BLOCKSTATE = new ModelProperty();
    public static final ModelProperty<IFramedMaterials> MATERIAL = new ModelProperty();
    public final ModelData modelData;

    protected ForgeFramedModelProperties() {
        this.modelData = ModelData.builder().build();
    }

    protected ForgeFramedModelProperties(IFramedBlockEntity blockEntity) {
        super(blockEntity);
        this.modelData = ModelData.builder().with(MATERIAL, (Object)blockEntity.material()).build();
    }

    public static ForgeFramedModelProperties getForgeModelData(IFramedBlockEntity blockEntity) {
        return new ForgeFramedModelProperties(blockEntity);
    }

    @Override
    public FramedModelContext makeContext(@Nullable BlockState state, RandomSource rand, Object renderData) {
        if (renderData instanceof ModelData) {
            ModelData m = (ModelData)renderData;
            return new FramedModelContext(state, rand).materialData(new MaterialData((IFramedMaterials)m.get(MATERIAL)));
        }
        return super.makeContext(state, rand, renderData);
    }

    @Override
    public FramedModelContext makeContext(ItemStack stack) {
        MaterialData data = ((FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY)).asMaterialData();
        Block block = Blocks.AIR;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        }
        return new FramedModelContext(block.defaultBlockState()).materialData(data);
    }
}

