/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public class ItemUpgrade
extends Item {
    private static int nextGroupId = 0;
    private boolean allowMultiple;
    private final int groupId;

    public ItemUpgrade(Item.Properties properties) {
        this(properties, ItemUpgrade.getNextGroupId());
    }

    protected ItemUpgrade(Item.Properties properties, int groupId) {
        super(properties);
        this.groupId = groupId;
    }

    protected static int getNextGroupId() {
        int groupId = nextGroupId++;
        return groupId;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public int getUpgradeGroup() {
        return this.groupId;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, tooltip, flag);
        ComponentUtil.appendSplitDescription(tooltip, this.getDescription());
    }

    @NotNull
    public Component getDescription() {
        return this.isEnabled() ? Component.translatable((String)(this.getDescriptionId() + ".desc")) : Component.translatable((String)"itemConfig.storagedrawers.disabled_upgrade").withStyle(ChatFormatting.RED);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setAllowMultiple(boolean allow) {
        this.allowMultiple = allow;
    }

    public boolean getAllowMultiple() {
        return this.allowMultiple;
    }
}

