/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.FaceSlotBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockDrawers
extends FaceSlotBlock
implements INetworked,
class_2343 {
    private static final class_265 AABB_NORTH_FULL = class_259.method_1072((class_265)class_259.method_1077(), (class_265)class_2248.method_9541((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (class_247)class_247.field_16886);
    private static final class_265 AABB_SOUTH_FULL = class_259.method_1072((class_265)class_259.method_1077(), (class_265)class_2248.method_9541((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (class_247)class_247.field_16886);
    private static final class_265 AABB_WEST_FULL = class_259.method_1072((class_265)class_259.method_1077(), (class_265)class_2248.method_9541((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (class_247)class_247.field_16886);
    private static final class_265 AABB_EAST_FULL = class_259.method_1072((class_265)class_259.method_1077(), (class_265)class_2248.method_9541((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (class_247)class_247.field_16886);
    private static final class_265 AABB_NORTH_HALF = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 AABB_SOUTH_HALF = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final class_265 AABB_WEST_HALF = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 AABB_EAST_HALF = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private final int drawerCount;
    private final boolean halfDepth;
    private final int storageUnits;
    public final class_238[] slotGeometry;
    public final class_238[] countGeometry;
    public final class_238[] labelGeometry;
    public final class_238[] indGeometry;
    public final class_238[] indBaseGeometry;
    private long ignoreEventTime;

    public BlockDrawers(int drawerCount, boolean halfDepth, int storageUnits, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.storageUnits = storageUnits;
        this.slotGeometry = new class_238[drawerCount];
        this.countGeometry = new class_238[drawerCount];
        this.labelGeometry = new class_238[drawerCount];
        this.indGeometry = new class_238[drawerCount];
        this.indBaseGeometry = new class_238[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.slotGeometry[i] = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.countGeometry[i] = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.labelGeometry[i] = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indGeometry[i] = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indBaseGeometry[i] = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public boolean retrimBlock(class_1937 world, class_2338 pos, class_1799 prototype) {
        return false;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public boolean repartitionBlock(class_1937 world, class_2338 pos, class_1799 prototype) {
        return false;
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public boolean isHalfDepth() {
        return this.halfDepth;
    }

    public int getStorageUnits() {
        return this.storageUnits;
    }

    public String getNameTypeKey() {
        String type = this.halfDepth ? "half" : "full";
        return "block.storagedrawers.type." + type + "_drawers_" + this.getDrawerCount();
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        switch (direction) {
            case field_11034: {
                return this.halfDepth ? AABB_EAST_HALF : AABB_EAST_FULL;
            }
            case field_11039: {
                return this.halfDepth ? AABB_WEST_HALF : AABB_WEST_FULL;
            }
            case field_11035: {
                return this.halfDepth ? AABB_SOUTH_HALF : AABB_SOUTH_FULL;
            }
        }
        return this.halfDepth ? AABB_NORTH_HALF : AABB_NORTH_FULL;
    }

    public boolean method_9516(@NotNull class_2680 state, @NotNull class_1922 getter, @NotNull class_2338 pos, @NotNull class_10 type) {
        return false;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    public void method_9567(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1309 entity, @NotNull class_1799 stack) {
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        class_2487 tag = stack.method_7941("tile");
        if (tag != null) {
            blockEntity.readPortable(tag);
        }
        if (stack.method_7938()) {
            blockEntity.customName().setName(stack.method_7964());
        }
        ItemKey key = null;
        if (entity != null) {
            class_1792 class_17922 = entity.method_6079().method_7909();
            if (class_17922 instanceof ItemKey) {
                ItemKey itemKey;
                key = itemKey = (ItemKey)class_17922;
            } else {
                class_17922 = entity.method_6079().method_7909();
                if (class_17922 instanceof ItemKeyring) {
                    ItemKeyring itemKeyring = (ItemKeyring)class_17922;
                    key = itemKeyring.getKey().method_7909();
                }
            }
        }
        if (key != null) {
            IDrawerAttributes _attrs = blockEntity.getCapability(Capabilities.DRAWER_ATTRIBUTES);
            if (_attrs == null) {
                _attrs = EmptyDrawerAttributes.EMPTY;
            }
            if (_attrs instanceof IDrawerAttributesModifiable) {
                IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
                if (key == ModItems.DRAWER_KEY.get()) {
                    attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
                    attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
                } else if (key == ModItems.QUANTIFY_KEY.get()) {
                    attrs.setIsShowingQuantity(true);
                } else if (key == ModItems.SHROUD_KEY.get()) {
                    attrs.setIsConcealed(true);
                }
            }
        }
    }

    @Deprecated
    protected int getDrawerSlot(class_2350 correctSide, @NotNull class_243 normalizedHit) {
        return this.getFaceSlot(correctSide, normalizedHit);
    }

    @Deprecated
    protected boolean hitAny(class_2350 side, class_243 normalizedHit) {
        return this.hitWithinArea(side, normalizedHit, 0.0625f, 0.9375f);
    }

    @Deprecated
    protected boolean hitTop(@NotNull class_243 normalizedHit) {
        return this.hitWithinY(normalizedHit, 0.5f, 1.0f);
    }

    @Deprecated
    protected boolean hitLeft(class_2350 side, @NotNull class_243 normalizedHit) {
        return this.hitWithinX(side, normalizedHit, 0.0f, 0.5f);
    }

    @Override
    public Optional<class_1269> useSlotInvertible(FaceSlotBlock.InteractContext context) {
        class_1799 item = context.player.method_5998(class_1268.field_5808);
        if (item.method_7960() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue() && !context.level.field_9236 && context.player.method_5715()) {
            this.openUI(context);
            return Optional.of(class_1269.field_5812);
        }
        return Optional.empty();
    }

    @Override
    public Optional<class_1269> useSlot(FaceSlotBlock.InteractContext context) {
        class_1799 item = context.player.method_5998(class_1268.field_5808);
        BlockEntityDrawers blockEntity = context.getCheckedEntity(BlockEntityDrawers.class);
        if (!SecurityManager.hasAccess(context.player, blockEntity)) {
            return Optional.of(class_1269.field_5811);
        }
        class_1799 keyItem = null;
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof ItemKeyring) {
            ItemKeyring keyring = (ItemKeyring)class_17922;
            keyItem = keyring.getKey();
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableDetachedDrawers.get()).booleanValue() && context.slot >= 0) {
            if (item.method_7909() == ModItems.DRAWER_PULLER.get() || keyItem != null && keyItem.method_7909() == ModItems.DRAWER_PULLER.get()) {
                this.interactPullDrawer(context);
                return Optional.of(class_1269.field_5812);
            }
            if (item.method_7909() instanceof ItemDetachedDrawer) {
                this.interactReturnDrawer(context, item);
                return Optional.of(class_1269.field_5812);
            }
        }
        if (class_2248.method_9503((class_1792)item.method_7909()) instanceof BlockTrim && context.slot >= 0 && context.player.method_5715()) {
            if (!this.retrimBlock(context.level, context.pos, item)) {
                return Optional.of(class_1269.field_5811);
            }
            if (!context.player.method_7337()) {
                item.method_7934(1);
                if (item.method_7947() <= 0) {
                    context.player.method_31548().method_5447(context.player.method_31548().field_7545, class_1799.field_8037);
                }
                context.level.method_8396(null, context.pos, class_3417.field_14718, class_3419.field_15248, 0.2f, ((context.level.field_9229.method_43057() - context.level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            }
            return Optional.of(class_1269.field_5812);
        }
        if (class_2248.method_9503((class_1792)item.method_7909()) instanceof BlockDrawers && context.slot >= 0 && context.player.method_5715()) {
            if (!this.repartitionBlock(context.level, context.pos, item)) {
                return Optional.of(class_1269.field_5811);
            }
            if (!context.player.method_7337()) {
                item.method_7934(1);
                if (item.method_7947() <= 0) {
                    context.player.method_31548().method_5447(context.player.method_31548().field_7545, class_1799.field_8037);
                }
                context.level.method_8396(null, context.pos, class_3417.field_14718, class_3419.field_15248, 0.2f, ((context.level.field_9229.method_43057() - context.level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            }
            return Optional.of(class_1269.field_5812);
        }
        if (item.method_7909() instanceof ItemPersonalKey || keyItem != null && keyItem.method_7909() instanceof ItemPersonalKey) {
            if (keyItem != null) {
                item = keyItem;
            }
            String securityKey = ((ItemPersonalKey)item.method_7909()).getSecurityProviderKey();
            ISecurityProvider provider = ModSecurity.registry.getProvider(securityKey);
            if (blockEntity.getOwner() == null) {
                blockEntity.setOwner(context.player.method_5667());
                blockEntity.setSecurityProvider(provider);
            } else if (SecurityManager.hasOwnership(context.player.method_7334(), blockEntity)) {
                blockEntity.setOwner(null);
                blockEntity.setSecurityProvider(null);
            } else {
                return Optional.of(class_1269.field_5811);
            }
            return Optional.of(class_1269.field_5812);
        }
        if (item.method_7909() instanceof ItemKey || item.method_7909() instanceof ItemKeyring) {
            return Optional.of(class_1269.field_5811);
        }
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class);
        if (item.method_7909() instanceof ItemUpgrade && !context.player.method_5715()) {
            if (entity.getGroup().hasMissingDrawers() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.forceDetachedDrawersMaxCapacityCheck.get()).booleanValue()) {
                if (!context.level.field_9236) {
                    context.player.method_7353((class_2561)class_2561.method_43471((String)"message.storagedrawers.missing_slots_upgrade"), true);
                }
                return Optional.of(class_1269.field_5811);
            }
            class_1792 class_17923 = item.method_7909();
            if (class_17923 instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote remote = (ItemUpgradeRemote)class_17923;
                if (entity.upgrades().hasRemoteUpgrade() && remote.isBound()) {
                    entity.upgrades().updateRemoteUpgradeBinding(item);
                    class_2338 pos = ItemUpgradeRemote.getBoundPosition(item);
                    if (pos != null) {
                        context.player.method_7353((class_2561)class_2561.method_43469((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}), true);
                    }
                    return Optional.of(class_1269.field_5812);
                }
            }
            if (!entity.upgrades().canAddUpgrade(item)) {
                if (!context.level.field_9236) {
                    context.player.method_7353((class_2561)class_2561.method_43471((String)"message.storagedrawers.cannot_add_upgrade"), true);
                }
                return Optional.of(class_1269.field_5811);
            }
            if (!entity.upgrades().addUpgrade(item)) {
                if (!context.level.field_9236) {
                    context.player.method_7353((class_2561)class_2561.method_43471((String)"message.storagedrawers.max_upgrades"), true);
                }
                return Optional.of(class_1269.field_5811);
            }
            context.level.method_8413(context.pos, context.state, context.state, 3);
            if (!context.player.method_7337()) {
                item.method_7934(1);
                if (item.method_7947() <= 0) {
                    context.player.method_31548().method_5447(context.player.method_31548().field_7545, class_1799.field_8037);
                }
            }
            return Optional.of(class_1269.field_5812);
        }
        return Optional.empty();
    }

    private void openUI(FaceSlotBlock.InteractContext context) {
        class_3908 provider = context.state.method_26196(context.level, context.pos);
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Open BlockDrawers UI " + context.pos);
        }
        if (provider instanceof ContentMenuProvider) {
            ContentMenuProvider menu = (ContentMenuProvider)provider;
            menu.openMenu((class_3222)context.player);
        }
    }

    @Nullable
    public class_3908 method_17454(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        BlockEntityDrawers blockEntityDrawers = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((class_1922)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return null;
        }
        return new BlockEntityDrawers.ContentProvider(blockEntityDrawers);
    }

    @Override
    public class_1269 putSlot(FaceSlotBlock.InteractContext context, boolean altAction) {
        class_1799 item = context.player.method_5998(class_1268.field_5808);
        BlockEntityDrawers blockEntityDrawers = context.getCheckedEntity(BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return class_1269.field_5814;
        }
        if (!SecurityManager.hasAccess(context.player, blockEntityDrawers)) {
            return class_1269.field_5811;
        }
        blockEntityDrawers.interactPutItemsIntoSlot(context.slot, context.player);
        if (item.method_7960()) {
            context.player.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 takeSlot(FaceSlotBlock.InteractContext context, boolean altAction) {
        BlockEntityDrawers blockEntityDrawers = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (blockEntityDrawers == null) {
            return class_1269.field_5814;
        }
        if (!SecurityManager.hasAccess(context.player, blockEntityDrawers)) {
            return class_1269.field_5811;
        }
        IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(context.slot);
        class_1799 item = altAction ? blockEntityDrawers.takeItemsFromSlot(context.slot, drawer.getStoredItemStackSize()) : blockEntityDrawers.takeItemsFromSlot(context.slot, 1);
        if (!item.method_7960()) {
            if (!context.player.method_31548().method_7394(item)) {
                this.dropItemStack(context.level, context.pos.method_10093(context.hit.method_17780()), context.player, item);
                context.level.method_8413(context.pos, context.state, context.state, 3);
            } else {
                context.level.method_8396(null, context.pos, class_3417.field_15197, class_3419.field_15248, 0.2f, ((context.level.field_9229.method_43057() - context.level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        return class_1269.field_5812;
    }

    public boolean interactPullDrawer(FaceSlotBlock.InteractContext context) {
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (entity == null) {
            return false;
        }
        IDrawer drawer = entity.getGroup().getDrawer(context.slot);
        if (!drawer.isEnabled() || drawer.isMissing() || !drawer.canDetach()) {
            return false;
        }
        class_1799 detachedDrawer = this.pullDrawer(entity, context.slot);
        if (!detachedDrawer.method_7960()) {
            drawer.setDetached(true);
        }
        this.giveOrDropItemStack(context, detachedDrawer);
        return true;
    }

    public boolean interactReturnDrawer(FaceSlotBlock.InteractContext context, class_1799 detachedDrawer) {
        if (detachedDrawer.method_7960()) {
            return false;
        }
        BlockEntityDrawers entity = context.getCheckedEntity(BlockEntityDrawers.class, BlockDrawers.class);
        if (entity == null) {
            return false;
        }
        if (!entity.interactReplaceDrawer(context.slot, detachedDrawer)) {
            return false;
        }
        if (detachedDrawer.method_7909() == ModItems.DETACHED_DRAWER.get()) {
            detachedDrawer.method_7939(detachedDrawer.method_7947() - 1);
            if (detachedDrawer.method_7947() > 0) {
                return true;
            }
        }
        context.player.method_6122(class_1268.field_5808, class_1799.field_8037);
        return true;
    }

    private class_1799 pullDrawer(BlockEntityDrawers group, int slot) {
        int cap = group.getEffectiveDrawerCapacity() * group.upgrades().getStorageMultiplier();
        class_1792 baseItem = (class_1792)ModItems.DETACHED_DRAWER_FULL.get();
        IDrawer drawer = group.getDrawer(slot);
        DetachedDrawerData data = new DetachedDrawerData(drawer, cap);
        if (drawer.isEmpty()) {
            baseItem = (class_1792)ModItems.DETACHED_DRAWER.get();
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.heavyDrawers.get()).booleanValue() && !group.upgrades().hasPortabilityUpgrade()) {
            data.setIsHeavy(true);
        }
        class_1799 stack = new class_1799((class_1935)baseItem, 1);
        stack.method_7980(data.serializeNBT());
        return stack;
    }

    private void giveOrDropItemStack(FaceSlotBlock.InteractContext context, @NotNull class_1799 item) {
        if (!item.method_7960()) {
            if (!context.player.method_31548().method_7394(item)) {
                this.dropItemStack(context.level, context.pos.method_10093(context.hit.method_17780()), context.player, item);
                context.level.method_8413(context.pos, context.state, context.state, 3);
            } else {
                context.level.method_8396(null, context.pos, class_3417.field_15197, class_3419.field_15248, 0.2f, ((context.level.field_9229.method_43057() - context.level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    private void dropItemStack(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1799 stack) {
        class_1542 entity = new class_1542(world, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.3f), (double)((float)pos.method_10260() + 0.5f), stack);
        class_243 motion = entity.method_18798();
        entity.method_5762(-motion.field_1352, -motion.field_1351, -motion.field_1350);
        world.method_8649((class_1297)entity);
    }

    @NotNull
    public List<class_1799> method_9560(@NotNull class_2680 state, class_8567.class_8568 builder) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        items.add(this.getMainDrop(state, (BlockEntityDrawers)builder.method_51876(class_181.field_1228)));
        return items;
    }

    protected class_1799 getMainDrop(class_2680 state, BlockEntityDrawers tile) {
        int i;
        class_1799 drop = new class_1799((class_1935)this);
        if (tile == null) {
            return drop;
        }
        class_2487 data = drop.method_7969();
        if (data == null) {
            data = new class_2487();
        }
        boolean hasContents = false;
        for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer.isEmpty() && !drawer.isMissing()) continue;
            hasContents = true;
        }
        for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
            if (tile.upgrades().getUpgrade(i).method_7960()) continue;
            hasContents = true;
        }
        if (hasContents) {
            class_2487 tiledata = tile.method_38244();
            data.method_10566("tile", (class_2520)tiledata);
            drop.method_7980(data);
        }
        if (tile.customName().hasCustomName()) {
            drop.method_7977(tile.customName().getDisplayName());
        }
        return drop;
    }

    public boolean method_9506(@NotNull class_2680 state) {
        return (Boolean)ModCommonConfig.INSTANCE.GENERAL.enableAnalogRedstone.get() == false;
    }

    public int method_9524(@NotNull class_2680 state, @NotNull class_1922 blockAccess, @NotNull class_2338 pos, @NotNull class_2350 side) {
        if (!this.method_9506(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity(blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public int method_9603(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_2350 side) {
        return side == class_2350.field_11036 ? this.method_9524(state, worldIn, pos, side) : 0;
    }

    public void method_9536(class_2680 p_51538_, class_1937 p_51539_, class_2338 p_51540_, class_2680 p_51541_, boolean p_51542_) {
        if (!p_51538_.method_27852(p_51541_.method_26204())) {
            p_51539_.method_8455(p_51540_, (class_2248)this);
            super.method_9536(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 blockAccess, class_2338 pos) {
        if (!this.method_9498(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((class_1922)blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public boolean method_9526(@NotNull class_2680 state) {
        return true;
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_5819 rand) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("BlockDrawers [{}] tick", (Object)pos);
        }
        if (world.field_9236) {
            return;
        }
        BlockEntityDrawers blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.validateBoundController();
    }
}

