/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.SpriteReplacementModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_7923;

public abstract class MaterialModelDecorator<C extends FramedModelContext>
extends ModelDecorator<C> {
    protected final DrawerModelStore.FrameMatSet matSet;
    protected final boolean shaded;
    private static Map<class_1087, Map<class_2960, class_1087>> replacementCache = new HashMap<class_1087, Map<class_2960, class_1087>>();

    public MaterialModelDecorator(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
        this.matSet = matSet;
        this.shaded = shaded;
    }

    @Override
    public boolean shouldRenderItem() {
        return true;
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return true;
        }
        MaterialData matData = context.materialData();
        return matData == null || matData.getEffectiveSide().method_7960();
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier, class_1799 stack) {
        return this.shouldRenderBase(contextSupplier);
    }

    @Override
    public void emitQuads(Supplier<C> contextSupplier, BiConsumer<class_1087, class_1921> emitModel) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return;
        }
        MaterialData matData = context.materialData();
        if (matData != null && !matData.getEffectiveSide().method_7960()) {
            class_1921 renderType = context.renderType();
            if (renderType == null || renderType == class_1921.method_23579()) {
                this.emitFramedQuads(context, emitModel);
            }
            if (this.shaded && (renderType == null || renderType == class_1921.method_23583())) {
                this.emitFramedOverlayQuads(context, emitModel);
            }
        }
    }

    @Override
    public void emitItemQuads(Supplier<C> contextSupplier, BiConsumer<class_1087, class_1921> emitModel, class_1799 stack) {
        FramedModelContext context = (FramedModelContext)contextSupplier.get();
        if (context == null) {
            return;
        }
        MaterialData matData = context.materialData();
        if (matData != null && !matData.getEffectiveSide().method_7960()) {
            this.emitFramedQuads(context, emitModel);
            if (this.shaded) {
                this.emitFramedOverlayQuads(context, emitModel);
            }
        }
    }

    @Override
    public List<class_1921> getRenderTypes(class_2680 state) {
        if (this.shaded) {
            return List.of(class_1921.method_23579(), class_1921.method_23583());
        }
        return List.of(class_1921.method_23579());
    }

    @Override
    public List<class_1921> getRenderTypes(class_1799 stack) {
        if (this.shaded) {
            return List.of(class_4722.method_24074(), class_4722.method_24076());
        }
        return List.of(class_4722.method_24074());
    }

    private class_1087 getReplacementModel(class_1087 baseModel, class_1799 material) {
        Map<Object, Object> matCache;
        if (replacementCache.containsKey(baseModel)) {
            matCache = replacementCache.get(baseModel);
        } else {
            matCache = new HashMap();
            replacementCache.put(baseModel, matCache);
        }
        class_2960 matName = class_7923.field_41178.method_10221((Object)material.method_7909());
        class_1087 replacedModel = null;
        if (matCache.containsKey(matName)) {
            replacedModel = (class_1087)matCache.get(matName);
        } else {
            replacedModel = new SpriteReplacementModel(baseModel, material);
            matCache.put(matName, replacedModel);
        }
        return replacedModel;
    }

    public void emitFramedQuads(FramedModelContext context, BiConsumer<class_1087, class_1921> emitModel) {
        class_2248 block = context.state().method_26204();
        if (block instanceof IFramedBlock) {
            IFramedBlock fb = (IFramedBlock)block;
            MaterialData matData = context.materialData();
            if (matData != null && !matData.isEmpty()) {
                if (this.matSet.sidePart() != null && fb.supportsFrameMaterial(FrameMaterial.SIDE)) {
                    emitModel.accept(this.getReplacementModel(this.getStoreModel(context, this.matSet.sidePart()), matData.getEffectiveSide()), class_1921.method_23579());
                }
                if (this.matSet.trimPart() != null && fb.supportsFrameMaterial(FrameMaterial.TRIM)) {
                    emitModel.accept(this.getReplacementModel(this.getStoreModel(context, this.matSet.trimPart()), matData.getEffectiveTrim()), class_1921.method_23579());
                }
                if (this.matSet.frontPart() != null && fb.supportsFrameMaterial(FrameMaterial.FRONT)) {
                    emitModel.accept(this.getReplacementModel(this.getStoreModel(context, this.matSet.frontPart()), matData.getEffectiveFront()), class_1921.method_23579());
                }
            }
        }
    }

    public void emitFramedOverlayQuads(FramedModelContext context, BiConsumer<class_1087, class_1921> emitModel) {
        MaterialData matData = context.materialData();
        if (matData != null && !matData.isEmpty()) {
            if (this.matSet.shadeFrontPart() != null) {
                emitModel.accept(this.getStoreModel(context, this.matSet.shadeFrontPart()), class_1921.method_23583());
            }
            if (this.matSet.shadeSidePart() != null) {
                emitModel.accept(this.getStoreModel(context, this.matSet.shadeSidePart()), class_1921.method_23583());
            }
        }
    }

    protected abstract class_1087 getStoreModel(FramedModelContext var1, DrawerModelStore.DynamicPart var2);

    public static class FacingSizedOpen<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSizedOpen(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected class_1087 getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            class_2350 dir = (class_2350)context.state().method_11654((class_2769)BlockDrawers.field_11177);
            boolean half = false;
            EnumCompDrawer open = EnumCompDrawer.OPEN1;
            class_2248 block = context.state().method_26204();
            if (block instanceof BlockCompDrawers) {
                BlockCompDrawers drawers = (BlockCompDrawers)block;
                half = drawers.isHalfDepth();
                open = (EnumCompDrawer)((Object)context.state().method_11654(BlockCompDrawers.SLOTS));
            }
            return DrawerModelStore.getModel(part, dir, half, open);
        }
    }

    public static class FacingSizedSlotted<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSizedSlotted(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected class_1087 getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            class_2350 dir = (class_2350)context.state().method_11654((class_2769)BlockDrawers.field_11177);
            boolean half = false;
            int count = 1;
            class_2248 block = context.state().method_26204();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
                count = drawers.getDrawerCount();
            }
            return DrawerModelStore.getModel(part, dir, half, count);
        }
    }

    public static class FacingSized<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public FacingSized(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected class_1087 getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            class_2350 dir = (class_2350)context.state().method_11654((class_2769)BlockDrawers.field_11177);
            boolean half = false;
            class_2248 block = context.state().method_26204();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
            }
            return DrawerModelStore.getModel(part, dir, half);
        }
    }

    public static class Facing<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public Facing(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected class_1087 getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            class_2350 dir = (class_2350)context.state().method_11654((class_2769)BlockDrawers.field_11177);
            return DrawerModelStore.getModel(part, dir);
        }
    }

    public static class Single<C extends FramedModelContext>
    extends MaterialModelDecorator<C> {
        public Single(DrawerModelStore.FrameMatSet matSet, boolean shaded) {
            super(matSet, shaded);
        }

        @Override
        protected class_1087 getStoreModel(FramedModelContext context, DrawerModelStore.DynamicPart part) {
            return DrawerModelStore.getModel(part);
        }
    }
}

