/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDrawers
extends class_1747
implements IPortable {
    public ItemDrawers(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        class_5250 textCapacity = class_2561.method_43469((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)textCapacity).method_27692(class_124.field_1080));
        class_2487 tag = stack.method_7941("tile");
        if (tag != null) {
            class_5250 textSealed = class_2561.method_43471((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)textSealed).method_27692(class_124.field_1054));
        }
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.heavyDrawers.get()).booleanValue() && this.isHeavy(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.storagedrawers.drawers.too_heavy").method_27692(class_124.field_1061));
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        BlockStandardDrawers drawers;
        String matKey;
        String fallback = null;
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        if (block instanceof BlockStandardDrawers && (matKey = (drawers = (BlockStandardDrawers)block).getMatKey()) != null) {
            String mat = class_2561.method_43471((String)drawers.getNameMatKey()).getString();
            fallback = class_2561.method_43469((String)drawers.getNameTypeKey(), (Object[])new Object[]{mat}).getString();
        }
        return class_2561.method_48321((String)this.method_7866(stack), fallback);
    }

    @NotNull
    public class_2561 method_7848() {
        return class_2561.method_43471((String)(this.method_7876() + ".desc"));
    }

    @Override
    public boolean isHeavy(@NotNull class_1799 stack) {
        if (stack.method_7909() != this) {
            return false;
        }
        class_2487 tile = stack.method_7941("tile");
        if (tile == null || tile.method_33133()) {
            return false;
        }
        UpgradeData x = new UpgradeData(7);
        try {
            x.read(tile);
        }
        catch (ClassCastException e) {
            return false;
        }
        return !x.hasPortabilityUpgrade();
    }

    private int getCapacityForBlock(@NotNull class_1799 itemStack) {
        class_2248 block = class_2248.method_9503((class_1792)itemStack.method_7909());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * ModCommonConfig.INSTANCE.GENERAL.getBaseStackStorage();
        }
        return 0;
    }

    public boolean doesSneakBypassUse(class_1799 stack, class_4538 level, class_2338 pos, class_1657 player) {
        BlockDrawers bd;
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        return block instanceof BlockDrawers && (bd = (BlockDrawers)block).retrimType() != null;
    }
}

