/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeRemote
extends ItemUpgrade {
    private static final int remoteGroupId = ItemUpgrade.getNextGroupId();
    private final boolean groupUpgrade;
    private final boolean bound;

    public ItemUpgradeRemote(boolean groupUpgrade, boolean bound, class_1792.class_1793 properties) {
        super(properties, remoteGroupId);
        this.groupUpgrade = groupUpgrade;
        this.bound = bound;
    }

    @Override
    public boolean isEnabled() {
        if (this.groupUpgrade) {
            return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteGroupUpgrade.get();
        }
        return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteUpgrade.get();
    }

    @Override
    public void method_7851(@NotNull class_1799 itemStack, @Nullable class_1937 world, List<class_2561> list, class_1836 advanced) {
        super.method_7851(itemStack, world, list, advanced);
        class_2338 pos = ItemUpgradeRemote.getBoundPosition(itemStack);
        if (pos != null) {
            list.add((class_2561)class_2561.method_43469((String)(this.method_7876() + ".bound"), (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1054));
        } else {
            list.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".bound")).method_27692(class_124.field_1061));
        }
    }

    public static class_2338 getBoundPosition(class_1799 itemStack) {
        if (itemStack == null) {
            return null;
        }
        class_2487 tag = itemStack.method_7969();
        if (tag == null) {
            return null;
        }
        class_2487 posTag = tag.method_10562("bound_controller");
        if (posTag.method_33133()) {
            return null;
        }
        int x = posTag.method_10550("x");
        int y = posTag.method_10550("y");
        int z = posTag.method_10550("z");
        return new class_2338(x, y, z);
    }

    public static class_1799 setBoundController(class_1799 itemStack, BlockEntityController controller) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("remote upgrade [{}] set bound controller [{}]", (Object)itemStack, (Object)controller);
        }
        if (itemStack == null || controller == null) {
            return itemStack;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            class_2487 posTag = new class_2487();
            posTag.method_10569("x", controller.method_11016().method_10263());
            posTag.method_10569("y", controller.method_11016().method_10264());
            posTag.method_10569("z", controller.method_11016().method_10260());
            class_2487 tag = itemStack.method_7948();
            tag.method_10566("bound_controller", (class_2520)posTag);
            class_1799 newStack = new class_1799(item.isGroupUpgrade() ? (class_1935)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (class_1935)ModItems.REMOTE_UPGRADE_BOUND.get(), itemStack.method_7947());
            newStack.method_7980(tag);
            return newStack;
        }
        return itemStack;
    }

    public static class_1799 setUnbound(class_1799 itemStack) {
        class_1792 class_17922;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("remote upgrade [{}] set unbound", (Object)itemStack);
        }
        if (itemStack != null && (class_17922 = itemStack.method_7909()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            class_1799 newStack = new class_1799(item.isGroupUpgrade() ? (class_1935)ModItems.REMOTE_GROUP_UPGRADE.get() : (class_1935)ModItems.REMOTE_UPGRADE.get(), itemStack.method_7947());
            class_2487 tag = itemStack.method_7948();
            if (tag.method_10545("bound_controller")) {
                tag.method_10551("bound_controller");
            }
            newStack.method_7980(tag);
            return newStack;
        }
        return itemStack;
    }

    public static class_1799 copyControllerBinding(class_1799 refStack, class_1799 targetStack) {
        if (refStack == null || targetStack == null) {
            return targetStack;
        }
        class_1792 class_17922 = refStack.method_7909();
        if (class_17922 instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote refItem = (ItemUpgradeRemote)class_17922;
            class_17922 = targetStack.method_7909();
            if (class_17922 instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote targetItem = (ItemUpgradeRemote)class_17922;
                class_1792 newItem = targetItem.isGroupUpgrade() ? (refItem.isBound() ? (class_1792)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (class_1792)ModItems.REMOTE_GROUP_UPGRADE.get()) : (refItem.isBound() ? (class_1792)ModItems.REMOTE_UPGRADE_BOUND.get() : (class_1792)ModItems.REMOTE_UPGRADE.get());
                class_1799 newStack = new class_1799((class_1935)newItem, targetStack.method_7947());
                class_2487 targetTag = targetStack.method_7948().method_10553();
                class_2487 refTag = refStack.method_7948();
                if (refTag.method_10545("bound_controller")) {
                    targetTag.method_10566("bound_controller", (class_2520)refTag.method_10562("bound_controller"));
                }
                newStack.method_7980(targetTag);
                return newStack;
            }
        }
        return targetStack;
    }

    public static BlockEntityController getBoundController(class_1799 itemStack, class_1936 level) {
        if (level == null) {
            return null;
        }
        class_2338 pos = ItemUpgradeRemote.getBoundPosition(itemStack);
        if (pos == null) {
            return null;
        }
        class_2586 entity = level.method_8321(pos);
        if (entity instanceof BlockEntityController) {
            BlockEntityController bec = (BlockEntityController)entity;
            return bec;
        }
        return null;
    }

    public static void validateInventory(class_1661 inventory, class_1937 level) {
        if (level == null || inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ItemUpgradeRemote)) continue;
            ItemUpgradeRemote item = (ItemUpgradeRemote)class_17922;
            if (!item.bound || ItemUpgradeRemote.getBoundController(stack, (class_1936)level) != null) continue;
            inventory.method_5447(i, ItemUpgradeRemote.setUnbound(stack));
        }
    }

    public boolean isGroupUpgrade() {
        return this.groupUpgrade;
    }

    public boolean isBound() {
        return this.bound;
    }
}

