/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.modelprops;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FramedModelProperties
implements ModelContextSupplier<FramedModelContext> {
    public static final FramedModelProperties INSTANCE = new FramedModelProperties();
    public final IFramedMaterials material;

    protected FramedModelProperties() {
        this.material = null;
    }

    protected FramedModelProperties(IFramedBlockEntity blockEntity) {
        this.material = blockEntity.material();
    }

    public static FramedModelProperties getModelData(IFramedBlockEntity blockEntity) {
        return new FramedModelProperties(blockEntity);
    }

    @Override
    public FramedModelContext makeContext(@Nullable BlockState state, RandomSource rand, Object renderData) {
        FramedModelContext context = new FramedModelContext(state, rand);
        if (renderData instanceof FramedModelProperties) {
            FramedModelProperties props = (FramedModelProperties)renderData;
            context.materialData(new MaterialData(props.material));
        }
        return context;
    }

    @Override
    public FramedModelContext makeContext(ItemStack stack) {
        MaterialData data = ((FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY)).asMaterialData();
        Block block = Blocks.AIR;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        }
        return new FramedModelContext(block.defaultBlockState()).materialData(data);
    }
}

