/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.components.item.KeyringContents;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ClientKeyringTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/slot_highlight_front");
    private static final ResourceLocation SLOT_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/slot_background");
    private static final int SLOT_MARGIN = 4;
    private static final int SLOT_SIZE = 24;
    private static final int GRID_WIDTH = 96;
    private final KeyringContents contents;

    public ClientKeyringTooltip(KeyringContents contents) {
        this.contents = contents;
    }

    public int getHeight(Font font) {
        return this.backgroundHeight();
    }

    public int getWidth(Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return 96;
    }

    private int backgroundHeight() {
        return this.itemGridHeight() + 4;
    }

    private int getContentXOffset(int x) {
        return (x - 96) / 2;
    }

    private int itemGridHeight() {
        return this.gridSizeY() * 24;
    }

    private int gridSizeY() {
        return Mth.positiveCeilDiv((int)this.slotCount(), (int)this.contents.getShowRowSize());
    }

    private int slotCount() {
        return Math.min(this.contents.getMaxShowSize(), this.contents.size());
    }

    public void renderImage(Font font, int pX, int pY, int pW, int pH, GuiGraphics graphics) {
        if (this.contents.isEmpty()) {
            this.renderEmptyBundleTooltip(font, pX, pY, pW, pH, graphics);
        } else {
            this.renderBundleWithItemsTooltip(font, pX, pY, pW, pH, graphics);
        }
    }

    private void renderEmptyBundleTooltip(Font font, int pX, int pY, int pW, int pH, GuiGraphics graphics) {
    }

    private void renderBundleWithItemsTooltip(Font font, int pX, int pY, int pW, int pH, GuiGraphics graphics) {
        boolean overflow = this.contents.size() > 16;
        List<ItemStack> items = this.getShownItems(this.contents.getNumberOfItemsToShow());
        int x = pX + this.getContentXOffset(pW) + 96;
        int y = pY + this.gridSizeY() * 24;
        int index = 1;
        for (int iy = 1; iy <= this.gridSizeY(); ++iy) {
            for (int ix = 1; ix <= this.contents.getShowRowSize(); ++ix) {
                int xOff = x - ix * 24;
                int yOff = y - iy * 24;
                if (ClientKeyringTooltip.shouldRenderSurplusText(overflow, ix, iy)) {
                    ClientKeyringTooltip.renderCount(xOff, yOff, this.getAmountOfHiddenItems(items), font, graphics);
                    continue;
                }
                if (!ClientKeyringTooltip.shouldRenderItemSlot(items, index)) continue;
                this.renderSlot(index, xOff, yOff, items, index, font, graphics);
                ++index;
            }
        }
        this.drawSelectedItemTooltip(font, graphics, pX, pY, pW);
    }

    private List<ItemStack> getShownItems(int showCount) {
        int count = Math.min(this.contents.size(), showCount);
        return this.contents.itemCopyStream().toList().subList(0, count);
    }

    private static boolean shouldRenderSurplusText(boolean overflow, int ix, int iy) {
        return overflow && ix * iy == 1;
    }

    private int getAmountOfHiddenItems(List<ItemStack> items) {
        return this.contents.itemCopyStream().skip(items.size()).mapToInt(ItemStack::getCount).sum();
    }

    private static boolean shouldRenderItemSlot(List<ItemStack> items, int index) {
        return items.size() >= index;
    }

    private static void renderCount(int x, int y, int hiddenCount, Font font, GuiGraphics graphics) {
        graphics.drawCenteredString(font, "+" + hiddenCount, x + 12, y + 10, -1);
    }

    private void renderSlot(int index, int pX, int pY, List<ItemStack> items, int renderIndex, Font font, GuiGraphics graphics) {
        int itemIndex = items.size() - index;
        boolean selected = itemIndex == this.contents.getSelectedItem();
        ItemStack item = items.get(itemIndex);
        if (selected) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, pX, pY, 24, 24);
        } else {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_BACKGROUND_SPRITE, pX, pY, 24, 24);
        }
        graphics.renderItem(item, pX + 4, pY + 4, renderIndex);
        graphics.renderItemDecorations(font, item, pX + 4, pY + 4);
        if (selected) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, pX, pY, 24, 24);
        }
    }

    private void drawSelectedItemTooltip(Font font, GuiGraphics graphics, int pX, int pY, int pW) {
        if (this.contents.hasSelectedItem()) {
            ItemStack item = this.contents.getItemUnsafe(this.contents.getSelectedItem());
            Component hoverComponent = item.getStyledHoverName();
            int textWidth = font.width(hoverComponent.getVisualOrderText());
            int textOffset = pX + pW / 2 - 12;
            ClientTooltipComponent tooltip = ClientTooltipComponent.create((FormattedCharSequence)hoverComponent.getVisualOrderText());
            graphics.renderTooltip(font, List.of(tooltip), textOffset - textWidth / 2, pY - 15, DefaultTooltipPositioner.INSTANCE, (ResourceLocation)item.get(DataComponents.TOOLTIP_STYLE));
        }
    }
}

