/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.render.ChameleonBlockModelPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SpriteReplacementModel
extends ParentModel {
    private TextureAtlasSprite sprite;
    private ChunkSectionLayer layer;
    private Map<BlockModelPart, ChameleonBlockModelPart> cache = new HashMap<BlockModelPart, ChameleonBlockModelPart>();

    public SpriteReplacementModel(@NotNull BlockStateModel parent, TextureAtlasSprite sprite) {
        super(parent);
        this.sprite = sprite;
    }

    public SpriteReplacementModel(@NotNull BlockStateModel parent, BlockStateModel replacement, ChunkSectionLayer renderLayer) {
        super(parent);
        this.sprite = replacement.particleIcon();
        this.layer = renderLayer;
    }

    public SpriteReplacementModel(@NotNull BlockStateModel parent, ItemStack stack, ChunkSectionLayer renderLayer) {
        super(parent);
        Item item;
        if (stack != null && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockRenderDispatcher disp = Minecraft.getInstance().getBlockRenderer();
            BlockStateModel model = disp.getBlockModel(block.defaultBlockState());
            this.sprite = model.particleIcon();
        }
        this.layer = renderLayer;
    }

    public SpriteReplacementModel(@NotNull BlockStateModel parent, ItemStack stack) {
        this(parent, stack, null);
    }

    @Override
    public void collectParts(RandomSource randomSource, List<BlockModelPart> list) {
        if (this.sprite == null) {
            super.collectParts(randomSource, list);
            return;
        }
        this.parent.collectParts(randomSource).forEach(part -> {
            if (this.cache.containsKey(part)) {
                list.add(this.cache.get(part));
            } else {
                ChameleonBlockModelPart replacement = ChameleonServices.RENDER.createReplacementPart((BlockModelPart)part, this.sprite);
                replacement.setRenderType(this.layer);
                list.add(replacement);
            }
        });
    }

    @Override
    public TextureAtlasSprite particleIcon() {
        if (this.sprite == null) {
            return super.particleIcon();
        }
        return this.sprite;
    }
}

