/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;

public enum DecoratorRenderType {
    SOLID,
    CUTOUT,
    TRANSLUCENT;


    public static DecoratorRenderType fromItemType(ChunkSectionLayer renderType) {
        if (renderType == null) {
            return null;
        }
        return switch (renderType) {
            case ChunkSectionLayer.SOLID -> SOLID;
            case ChunkSectionLayer.CUTOUT, ChunkSectionLayer.CUTOUT_MIPPED -> CUTOUT;
            case ChunkSectionLayer.TRANSLUCENT -> TRANSLUCENT;
            default -> null;
        };
    }

    public static DecoratorRenderType fromItemType(RenderType renderType) {
        if (renderType == Sheets.solidBlockSheet()) {
            return SOLID;
        }
        if (renderType == Sheets.cutoutBlockSheet()) {
            return CUTOUT;
        }
        if (renderType == Sheets.translucentItemSheet()) {
            return TRANSLUCENT;
        }
        return null;
    }

    public static ChunkSectionLayer toChunkType(DecoratorRenderType renderType) {
        if (renderType == null) {
            return null;
        }
        return switch (renderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ChunkSectionLayer.SOLID;
            case 1 -> ChunkSectionLayer.CUTOUT_MIPPED;
            case 2 -> ChunkSectionLayer.TRANSLUCENT;
        };
    }

    public static RenderType toItemType(DecoratorRenderType renderType) {
        if (renderType == null) {
            return null;
        }
        return switch (renderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Sheets.solidBlockSheet();
            case 1 -> Sheets.cutoutBlockSheet();
            case 2 -> Sheets.translucentItemSheet();
        };
    }
}

