/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.BlockKeyButton;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.KeyType;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedController;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedTrim;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacing;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSized;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedOpen;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedSlotted;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaTrans;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.api.ChameleonInit;
import com.texelsaurus.minecraft.chameleon.registry.ChameleonRegistry;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public final class ModBlocks {
    public static final ChameleonRegistry<Block> BLOCKS = ChameleonServices.REGISTRY.create(BuiltInRegistries.BLOCK, "storagedrawers");
    public static final List<String> EXCLUDE_ITEMS = new ArrayList<String>();
    public static final RegistryEntry<BlockStandardDrawers> OAK_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("oak"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> OAK_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("oak"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> OAK_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("oak"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> OAK_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("oak"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> OAK_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("oak"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> OAK_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("oak"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("spruce"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("spruce"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> SPRUCE_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("spruce"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("spruce"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("spruce"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> SPRUCE_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("spruce"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> BIRCH_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("birch"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> BIRCH_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("birch"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> BIRCH_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("birch"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> BIRCH_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("birch"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> BIRCH_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("birch"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> BIRCH_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("birch"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("jungle"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("jungle"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> JUNGLE_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("jungle"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("jungle"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("jungle"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> JUNGLE_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("jungle"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> ACACIA_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("acacia"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> ACACIA_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("acacia"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> ACACIA_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("acacia"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> ACACIA_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("acacia"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> ACACIA_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("acacia"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> ACACIA_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("acacia"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("dark_oak"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("dark_oak"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> DARK_OAK_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("dark_oak"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("dark_oak"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("dark_oak"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> DARK_OAK_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("dark_oak"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> MANGROVE_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("mangrove"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> MANGROVE_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("mangrove"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> MANGROVE_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("mangrove"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> MANGROVE_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("mangrove"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> MANGROVE_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("mangrove"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> MANGROVE_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("mangrove"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> CHERRY_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("cherry"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> CHERRY_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("cherry"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> CHERRY_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("cherry"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> CHERRY_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("cherry"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> CHERRY_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("cherry"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> CHERRY_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("cherry"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> BAMBOO_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("bamboo"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> BAMBOO_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("bamboo"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> BAMBOO_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("bamboo"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> BAMBOO_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("bamboo"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> BAMBOO_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("bamboo"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> BAMBOO_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("bamboo"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("crimson"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("crimson"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> CRIMSON_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("crimson"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("crimson"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("crimson"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> CRIMSON_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("crimson"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> WARPED_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("warped"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> WARPED_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("warped"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> WARPED_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("warped"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> WARPED_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("warped"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> WARPED_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("warped"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> WARPED_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("warped"), 4, true);
    public static final RegistryEntry<BlockStandardDrawers> PALE_OAK_FULL_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("pale_oak"), 1, false);
    public static final RegistryEntry<BlockStandardDrawers> PALE_OAK_FULL_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("pale_oak"), 2, false);
    public static final RegistryEntry<BlockStandardDrawers> PALE_OAK_FULL_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("pale_oak"), 4, false);
    public static final RegistryEntry<BlockStandardDrawers> PALE_OAK_HALF_DRAWERS_1 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("pale_oak"), 1, true);
    public static final RegistryEntry<BlockStandardDrawers> PALE_OAK_HALF_DRAWERS_2 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("pale_oak"), 2, true);
    public static final RegistryEntry<BlockStandardDrawers> PALE_OAK_HALF_DRAWERS_4 = ModBlocks.registerWoodenDrawerBlock(ModBlocks.modLoc("pale_oak"), 4, true);
    public static final RegistryEntry<BlockFramedStandardDrawers> FRAMED_FULL_DRAWERS_1 = ModBlocks.registerFramedDrawerBlock("framed_full_drawers_1", 1, false);
    public static final RegistryEntry<BlockFramedStandardDrawers> FRAMED_FULL_DRAWERS_2 = ModBlocks.registerFramedDrawerBlock("framed_full_drawers_2", 2, false);
    public static final RegistryEntry<BlockFramedStandardDrawers> FRAMED_FULL_DRAWERS_4 = ModBlocks.registerFramedDrawerBlock("framed_full_drawers_4", 4, false);
    public static final RegistryEntry<BlockFramedStandardDrawers> FRAMED_HALF_DRAWERS_1 = ModBlocks.registerFramedDrawerBlock("framed_half_drawers_1", 1, true);
    public static final RegistryEntry<BlockFramedStandardDrawers> FRAMED_HALF_DRAWERS_2 = ModBlocks.registerFramedDrawerBlock("framed_half_drawers_2", 2, true);
    public static final RegistryEntry<BlockFramedStandardDrawers> FRAMED_HALF_DRAWERS_4 = ModBlocks.registerFramedDrawerBlock("framed_half_drawers_4", 4, true);
    public static final RegistryEntry<BlockCompDrawers> COMPACTING_DRAWERS_2 = ModBlocks.registerCompactingDrawerBlock("compacting_drawers_2", 2, false);
    public static final RegistryEntry<BlockCompDrawers> COMPACTING_DRAWERS_3 = ModBlocks.registerCompactingDrawerBlock("compacting_drawers_3", 3, false);
    public static final RegistryEntry<BlockCompDrawers> COMPACTING_HALF_DRAWERS_2 = ModBlocks.registerCompactingDrawerBlock("compacting_half_drawers_2", 2, true);
    public static final RegistryEntry<BlockCompDrawers> COMPACTING_HALF_DRAWERS_3 = ModBlocks.registerCompactingDrawerBlock("compacting_half_drawers_3", 3, true);
    public static final RegistryEntry<BlockFramedCompDrawers> FRAMED_COMPACTING_DRAWERS_2 = ModBlocks.registerFramedCompactingDrawerBlock("framed_compacting_drawers_2", 2, false);
    public static final RegistryEntry<BlockFramedCompDrawers> FRAMED_COMPACTING_DRAWERS_3 = ModBlocks.registerFramedCompactingDrawerBlock("framed_compacting_drawers_3", 3, false);
    public static final RegistryEntry<BlockFramedCompDrawers> FRAMED_COMPACTING_HALF_DRAWERS_2 = ModBlocks.registerFramedCompactingDrawerBlock("framed_compacting_half_drawers_2", 2, true);
    public static final RegistryEntry<BlockFramedCompDrawers> FRAMED_COMPACTING_HALF_DRAWERS_3 = ModBlocks.registerFramedCompactingDrawerBlock("framed_compacting_half_drawers_3", 3, true);
    public static final RegistryEntry<BlockTrim> OAK_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("oak"));
    public static final RegistryEntry<BlockTrim> SPRUCE_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("spruce"));
    public static final RegistryEntry<BlockTrim> BIRCH_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("birch"));
    public static final RegistryEntry<BlockTrim> JUNGLE_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("jungle"));
    public static final RegistryEntry<BlockTrim> ACACIA_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("acacia"));
    public static final RegistryEntry<BlockTrim> DARK_OAK_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("dark_oak"));
    public static final RegistryEntry<BlockTrim> MANGROVE_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("mangrove"));
    public static final RegistryEntry<BlockTrim> CHERRY_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("cherry"));
    public static final RegistryEntry<BlockTrim> BAMBOO_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("bamboo"));
    public static final RegistryEntry<BlockTrim> CRIMSON_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("crimson"));
    public static final RegistryEntry<BlockTrim> WARPED_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("warped"));
    public static final RegistryEntry<BlockTrim> PALE_OAK_TRIM = ModBlocks.registerTrimBlock(ModBlocks.modLoc("pale_oak"));
    public static final RegistryEntry<BlockFramedTrim> FRAMED_TRIM = ModBlocks.registerFramedTrimBlock("framed_trim");
    public static final RegistryEntry<BlockController> CONTROLLER = ModBlocks.registerControllerBlock("controller");
    public static final RegistryEntry<BlockControllerIO> CONTROLLER_IO = ModBlocks.registerControllerIOBlock("controller_io");
    public static final RegistryEntry<BlockFramedController> FRAMED_CONTROLLER = BLOCKS.register("framed_controller", () -> new BlockFramedController(ModBlocks.getStoneBlockProperties().setId(ModBlocks.modKey("framed_controller")).noOcclusion()));
    public static final RegistryEntry<BlockFramedControllerIO> FRAMED_CONTROLLER_IO = BLOCKS.register("framed_controller_io", () -> new BlockFramedControllerIO(ModBlocks.getStoneBlockProperties().setId(ModBlocks.modKey("framed_controller_io")).noOcclusion()));
    public static final RegistryEntry<BlockFramingTable> FRAMING_TABLE = ModBlocks.registerFramingTableBlock("framing_table");
    public static final RegistryEntry<BlockMeta> META_LOCKED = ModBlocks.registerMetaFacingSizedBlock("meta_locked");
    public static final RegistryEntry<BlockMeta> META_CLAIMED = ModBlocks.registerMetaFacingSizedBlock("meta_claimed");
    public static final RegistryEntry<BlockMeta> META_LOCKED_CLAIMED = ModBlocks.registerMetaFacingSizedBlock("meta_locked_claimed");
    public static final RegistryEntry<BlockMeta> META_VOID_ICON = ModBlocks.registerMetaBlock("meta_void_icon");
    public static final RegistryEntry<BlockMeta> META_SHROUD_ICON = ModBlocks.registerMetaBlock("meta_shroud_icon");
    public static final RegistryEntry<BlockMeta> META_SUSPEND_ICON = ModBlocks.registerMetaBlock("meta_suspend_icon");
    public static final RegistryEntry<BlockMeta> META_MAGNET_ICON = ModBlocks.registerMetaBlock("meta_magnet_icon");
    public static final RegistryEntry<BlockMeta> META_PRIORITY_P1_ICON = ModBlocks.registerMetaBlock("meta_priority_p1_icon");
    public static final RegistryEntry<BlockMeta> META_PRIORITY_P2_ICON = ModBlocks.registerMetaBlock("meta_priority_p2_icon");
    public static final RegistryEntry<BlockMeta> META_PRIORITY_N1_ICON = ModBlocks.registerMetaBlock("meta_priority_n1_icon");
    public static final RegistryEntry<BlockMeta> META_PRIORITY_N2_ICON = ModBlocks.registerMetaBlock("meta_priority_n2_icon");
    public static final RegistryEntry<BlockMeta> META_INDICATOR = ModBlocks.registerMetaFacingSizedSlotted124Block("meta_indicator");
    public static final RegistryEntry<BlockMeta> META_COMP_INDICATOR = ModBlocks.registerMetaFacingSizedSlotted23Block("meta_comp_indicator");
    public static final RegistryEntry<BlockMeta> META_RIGHT_LABEL = ModBlocks.registerMetaFacingSizedLabelBlock("meta_right_label");
    public static final RegistryEntry<BlockMeta> META_HOPPER = ModBlocks.registerMetaBlock("meta_hopper");
    public static final RegistryEntry<BlockMeta> META_MISSING_1_1 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_1_1");
    public static final RegistryEntry<BlockMeta> META_MISSING_2_1 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_2_1");
    public static final RegistryEntry<BlockMeta> META_MISSING_2_2 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_2_2");
    public static final RegistryEntry<BlockMeta> META_MISSING_4_1 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_4_1");
    public static final RegistryEntry<BlockMeta> META_MISSING_4_2 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_4_2");
    public static final RegistryEntry<BlockMeta> META_MISSING_4_3 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_4_3");
    public static final RegistryEntry<BlockMeta> META_MISSING_4_4 = ModBlocks.registerMetaFacingSizedBlock("meta_missing_slot_4_4");
    public static final RegistryEntry<BlockMeta> META_FRAMED_DRAWERS_SIDE = ModBlocks.registerMetaFacingSizedSlotted124Block("meta_framed_drawers_side");
    public static final RegistryEntry<BlockMeta> META_FRAMED_DRAWERS_TRIM = ModBlocks.registerMetaFacingSizedSlotted124Block("meta_framed_drawers_trim");
    public static final RegistryEntry<BlockMeta> META_FRAMED_DRAWERS_FRONT = ModBlocks.registerMetaFacingSizedSlotted124Block("meta_framed_drawers_front");
    public static final RegistryEntry<BlockMeta> META_FRAMED_DRAWERS_SHADING = ModBlocks.registerMetaFacingSizedSlotted124Block("meta_framed_drawers_shading");
    public static final RegistryEntry<BlockMeta> META_FRAMED_TRIM_SIDE = ModBlocks.registerMetaBlock("meta_framed_trim_side");
    public static final RegistryEntry<BlockMeta> META_FRAMED_TRIM_TRIM = ModBlocks.registerMetaBlock("meta_framed_trim_trim");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_SIDE = ModBlocks.registerMetaFacingBlock("meta_framed_controller_side");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_TRIM = ModBlocks.registerMetaFacingBlock("meta_framed_controller_trim");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_FRONT = ModBlocks.registerMetaFacingBlock("meta_framed_controller_front");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_SHADING = ModBlocks.registerMetaFacingBlock("meta_framed_controller_shading");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_IO_SIDE = ModBlocks.registerMetaBlock("meta_framed_controller_io_side");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_IO_TRIM = ModBlocks.registerMetaBlock("meta_framed_controller_io_trim");
    public static final RegistryEntry<BlockMeta> META_FRAMED_CONTROLLER_IO_SHADING = ModBlocks.registerMetaBlock("meta_framed_controller_io_shading");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_2_SIDE = ModBlocks.registerMetaFacingSizedOpen2Block("meta_framed_compdrawers_2_side");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_2_TRIM = ModBlocks.registerMetaFacingSizedOpen2Block("meta_framed_compdrawers_2_trim");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_2_FRONT = ModBlocks.registerMetaFacingSizedOpen2Block("meta_framed_compdrawers_2_front");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_2_SHADING = ModBlocks.registerMetaFacingSizedOpen2Block("meta_framed_compdrawers_2_shading");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_3_SIDE = ModBlocks.registerMetaFacingSizedOpen3Block("meta_framed_compdrawers_3_side");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_3_TRIM = ModBlocks.registerMetaFacingSizedOpen3Block("meta_framed_compdrawers_3_trim");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_3_FRONT = ModBlocks.registerMetaFacingSizedOpen3Block("meta_framed_compdrawers_3_front");
    public static final RegistryEntry<BlockMeta> META_FRAMED_COMPDRAWERS_3_SHADING = ModBlocks.registerMetaFacingSizedOpen3Block("meta_framed_compdrawers_3_shading");
    public static final RegistryEntry<BlockKeyButton> KEYBUTTON_DRAWER = BLOCKS.register("keybutton_drawer", () -> new BlockKeyButton(KeyType.DRAWER, BlockBehaviour.Properties.of().setId(ModBlocks.modKey("keybutton_drawer")).sound(SoundType.STONE)));
    public static final RegistryEntry<BlockKeyButton> KEYBUTTON_QUANTIFY = BLOCKS.register("keybutton_quantify", () -> new BlockKeyButton(KeyType.QUANTIFY, BlockBehaviour.Properties.of().setId(ModBlocks.modKey("keybutton_quantify")).sound(SoundType.STONE)));
    public static final RegistryEntry<BlockKeyButton> KEYBUTTON_CONCEALMENT = BLOCKS.register("keybutton_concealment", () -> new BlockKeyButton(KeyType.CONCEALMENT, BlockBehaviour.Properties.of().setId(ModBlocks.modKey("keybutton_concealment")).sound(SoundType.STONE)));

    private ModBlocks() {
    }

    static ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"storagedrawers", (String)name);
    }

    static ResourceKey<Block> modKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ModBlocks.modLoc(name));
    }

    static IDrawerConfig getStandardConfig(int drawerCount, boolean halfDepth) {
        ModCommonConfig.Drawers base = ModCommonConfig.INSTANCE.DRAWERS;
        if (drawerCount == 1) {
            return halfDepth ? base.halfDrawers1x1 : base.fullDrawers1x1;
        }
        if (drawerCount == 2) {
            return halfDepth ? base.halfDrawers1x2 : base.fullDrawers1x2;
        }
        if (drawerCount == 4) {
            return halfDepth ? base.halfDrawers2x2 : base.fullDrawers2x2;
        }
        return null;
    }

    static IDrawerConfig getCompConfig(boolean halfDepth) {
        ModCommonConfig.Drawers base = ModCommonConfig.INSTANCE.DRAWERS;
        return halfDepth ? base.halfCompacting : base.fullCompacting;
    }

    static RegistryEntry<BlockStandardDrawers> registerWoodenDrawerBlock(ResourceLocation name, int drawerCount, boolean halfDepth) {
        return ModBlocks.registerWoodenDrawerBlock(BLOCKS, name, drawerCount, halfDepth);
    }

    static RegistryEntry<BlockStandardDrawers> registerWoodenDrawerBlock(ChameleonRegistry<Block> register, String name, int drawerCount, boolean halfDepth) {
        IDrawerConfig config = ModBlocks.getStandardConfig(drawerCount, halfDepth);
        return register.register(name, () -> new BlockStandardDrawers(drawerCount, halfDepth, config, ModBlocks.getWoodenDrawerBlockProperties().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockStandardDrawers> registerWoodenDrawerBlock(ChameleonRegistry<Block> register, ResourceLocation material, int drawerCount, boolean halfDepth) {
        String name = material.getPath() + (halfDepth ? "_half_drawers_" : "_full_drawers_") + drawerCount;
        IDrawerConfig config = ModBlocks.getStandardConfig(drawerCount, halfDepth);
        return register.register(name, () -> new BlockStandardDrawers(drawerCount, halfDepth, config, ModBlocks.getWoodenDrawerBlockProperties().setId(ModBlocks.modKey(name))).setMatKey(material));
    }

    static RegistryEntry<BlockFramedStandardDrawers> registerFramedDrawerBlock(String name, int drawerCount, boolean halfDepth) {
        IDrawerConfig config = ModBlocks.getStandardConfig(drawerCount, halfDepth);
        return BLOCKS.register(name, () -> (BlockFramedStandardDrawers)new BlockFramedStandardDrawers(drawerCount, halfDepth, config, ModBlocks.getWoodenDrawerBlockProperties().setId(ModBlocks.modKey(name)).noOcclusion()).setMatKey("framed"));
    }

    static RegistryEntry<BlockCompDrawers> registerCompactingDrawerBlock(String name, int drawerCount, boolean halfDepth) {
        IDrawerConfig config = ModBlocks.getCompConfig(halfDepth);
        return BLOCKS.register(name, () -> new BlockCompDrawers(drawerCount, halfDepth, config, ModBlocks.getStoneDrawerBlockProperties().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockFramedCompDrawers> registerFramedCompactingDrawerBlock(String name, int drawerCount, boolean halfDepth) {
        IDrawerConfig config = ModBlocks.getCompConfig(halfDepth);
        return BLOCKS.register(name, () -> new BlockFramedCompDrawers(drawerCount, halfDepth, config, ModBlocks.getStoneDrawerBlockProperties().setId(ModBlocks.modKey(name)).noOcclusion()));
    }

    static RegistryEntry<BlockTrim> registerTrimBlock(ResourceLocation name) {
        return ModBlocks.registerTrimBlock(BLOCKS, name);
    }

    static RegistryEntry<BlockTrim> registerTrimBlock(ChameleonRegistry<Block> register, String name) {
        return register.register(name, () -> new BlockTrim(ModBlocks.getWoodenBlockProperties().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockTrim> registerTrimBlock(ChameleonRegistry<Block> register, ResourceLocation material) {
        String name = material.getPath() + "_trim";
        return register.register(name, () -> new BlockTrim(ModBlocks.getWoodenBlockProperties().setId(ModBlocks.modKey(name))).setMatKey(material));
    }

    static RegistryEntry<BlockFramedTrim> registerFramedTrimBlock(String name) {
        return BLOCKS.register(name, () -> (BlockFramedTrim)new BlockFramedTrim(ModBlocks.getWoodenDrawerBlockProperties().setId(ModBlocks.modKey(name)).noOcclusion().isViewBlocking((a, b, c) -> false)).setMatKey("framed"));
    }

    static RegistryEntry<BlockController> registerControllerBlock(String name) {
        return BLOCKS.register(name, () -> new BlockController(ModBlocks.getStoneBlockProperties().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockControllerIO> registerControllerIOBlock(String name) {
        return BLOCKS.register(name, () -> new BlockControllerIO(ModBlocks.getStoneBlockProperties().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockFramingTable> registerFramingTableBlock(String name) {
        return BLOCKS.register(name, () -> new BlockFramingTable(ModBlocks.getWoodenBlockProperties().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMeta(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaTransBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaTrans(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacing(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingSizedBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacingSized(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingSizedSlotted23Block(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacingSizedSlotted.Slots23(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingSizedSlotted124Block(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacingSizedSlotted.Slots124(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingSizedLabelBlock(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacingSizedSlotted.Label(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingSizedOpen2Block(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacingSizedOpen.Open2(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static RegistryEntry<BlockMeta> registerMetaFacingSizedOpen3Block(String name) {
        EXCLUDE_ITEMS.add(name);
        return BLOCKS.register(name, () -> new BlockMetaFacingSizedOpen.Open3(BlockBehaviour.Properties.of().air().setId(ModBlocks.modKey(name))));
    }

    static BlockBehaviour.Properties getWoodenBlockProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(3.0f, 4.0f);
    }

    static BlockBehaviour.Properties getWoodenDrawerBlockProperties() {
        return ModBlocks.getWoodenBlockProperties().isSuffocating(ModBlocks::predFalse).isRedstoneConductor(ModBlocks::predFalse);
    }

    static BlockBehaviour.Properties getStoneBlockProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(4.0f, 5.0f);
    }

    static BlockBehaviour.Properties getStoneDrawerBlockProperties() {
        return ModBlocks.getStoneBlockProperties().isSuffocating(ModBlocks::predFalse).isRedstoneConductor(ModBlocks::predFalse);
    }

    public static void init(ChameleonInit.InitContext context) {
        BLOCKS.init(context);
    }

    private static <B extends Block> Stream<B> getBlocksOfType(Class<B> blockClass) {
        return BLOCKS.getEntries().stream().map(Supplier::get).filter(blockClass::isInstance).map(blockClass::cast);
    }

    public static Stream<BlockDrawers> getDrawers() {
        return ModBlocks.getBlocksOfType(BlockDrawers.class);
    }

    public static Stream<BlockFramedStandardDrawers> getFramedDrawers() {
        return ModBlocks.getBlocksOfType(BlockFramedStandardDrawers.class);
    }

    public static Stream<BlockController> getControllers() {
        return ModBlocks.getBlocksOfType(BlockController.class);
    }

    public static Stream<BlockControllerIO> getControllerIOs() {
        return ModBlocks.getBlocksOfType(BlockControllerIO.class);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersOfType(Class<BD> drawerClass) {
        return ModBlocks.getBlocksOfType(drawerClass);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersOfTypeAndSize(Class<BD> drawerClass, int size) {
        return ModBlocks.getDrawersOfType(drawerClass).filter(blockDrawers -> blockDrawers.getDrawerCount() == size);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersOfTypeAndSizeAndDepth(Class<BD> drawerClass, int size, boolean halfDepth) {
        return ModBlocks.getDrawersOfTypeAndSize(drawerClass, size).filter(blockDrawers -> blockDrawers.isHalfDepth() == halfDepth);
    }

    public static <BD extends BlockDrawers> Stream<BD> getDrawersofTypeAndDepth(Class<BD> drawerClass, boolean halfDepth) {
        return ModBlocks.getDrawersOfType(drawerClass).filter(blockDrawers -> blockDrawers.isHalfDepth() == halfDepth);
    }

    public static Stream<BlockFramedTrim> getFramedTrim() {
        return ModBlocks.getBlocksOfType(BlockFramedTrim.class);
    }

    public static Stream<IFramedBlock> getFramedBlocks() {
        return BLOCKS.stream().map(Supplier::get).filter(IFramedBlock.class::isInstance).map(IFramedBlock.class::cast);
    }

    private static boolean predFalse(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }
}

