/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.components.item.DetachedDrawerContents;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.DetachedDrawerTooltip;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.NotNull;

public class ItemDetachedDrawer
extends Item
implements IPortable {
    public ItemDetachedDrawer(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)this);
        DetachedDrawerData data = new DetachedDrawerData();
        data.setStorageMultiplier(ModCommonConfig.INSTANCE.DRAWERS.getBaseStackStorage() * 8);
        ItemStack savedItem = data.getStoredItemPrototype().copyWithCount(data.getStoredItemCount());
        DetachedDrawerContents contents = new DetachedDrawerContents(savedItem, data.getStorageMultiplier(), data.isHeavy());
        stack.set((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get(), (Object)contents);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, display, tooltip, flag);
        ComponentUtil.appendSplitDescription(tooltip, this.getDescription());
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.heavyDrawers.get()).booleanValue() && this.isHeavy(context.registries(), stack)) {
            tooltip.accept((Component)Component.translatable((String)"tooltip.storagedrawers.drawers.too_heavy").withStyle(ChatFormatting.RED));
        }
    }

    @NotNull
    public Component getDescription() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.enable.get() != false ? Component.translatable((String)(this.getDescriptionId() + ".desc")) : Component.translatable((String)"itemConfig.storagedrawers.disabled_tool").withStyle(ChatFormatting.RED);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        TooltipDisplay tooltipdisplay = (TooltipDisplay)stack.getOrDefault(DataComponents.TOOLTIP_DISPLAY, (Object)TooltipDisplay.DEFAULT);
        if (!tooltipdisplay.shows((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get())) {
            return Optional.empty();
        }
        if (!stack.has((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get())) {
            return Optional.empty();
        }
        return Optional.ofNullable((DetachedDrawerContents)stack.get((DataComponentType)ModDataComponents.DETACHED_DRAWER_CONTENTS.get())).map(DetachedDrawerTooltip::new);
    }

    @Override
    public boolean isHeavy(HolderLookup.Provider provider, @NotNull ItemStack stack) {
        if (stack.getItem() != this) {
            return false;
        }
        CustomData cdata = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)provider, (CompoundTag)cdata.copyTag());
        DetachedDrawerData data = new DetachedDrawerData(input);
        return data.isHeavy() && data.getStoredItemCount() > data.getStoredItemStackSize();
    }

    public boolean canFitInsideContainerItems() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.canStoreInContainers.get();
    }
}

