/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;

public class ComponentUtil {
    public static List<MutableComponent> getSplitDescription(Item item) {
        Component description = item.getName();
        if (description.equals((Object)Component.empty())) {
            return new LinkedList<MutableComponent>();
        }
        return Arrays.stream(description.getString().split("\n")).map(Component::literal).toList();
    }

    public static List<MutableComponent> getSplitDescription(Component description) {
        return Arrays.stream(description.getString().split("\n")).map(Component::literal).toList();
    }

    public static void appendSplitDescription(Consumer<Component> list, Item item) {
        ComponentUtil.appendSplitDescription(list, item, ChatFormatting.GRAY);
    }

    public static void appendSplitDescription(Consumer<Component> list, Component description) {
        ComponentUtil.appendSplitDescription(list, description, ChatFormatting.GRAY);
    }

    public static void appendSplitDescription(Consumer<Component> list, Item item, ChatFormatting formatting) {
        for (MutableComponent component : ComponentUtil.getSplitDescription(item)) {
            list.accept((Component)component.withStyle(formatting));
        }
    }

    public static void appendSplitDescription(Consumer<Component> list, Component description, ChatFormatting formatting) {
        for (MutableComponent component : ComponentUtil.getSplitDescription(description)) {
            list.accept((Component)component.withStyle(formatting));
        }
    }
}

