/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.jaquadro.minecraft.storagedrawers.client.NeoForgeClient;
import com.texelsaurus.minecraft.chameleon.api.ChameleonInit;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import com.texelsaurus.minecraft.chameleon.registry.NeoforgeRegistryContext;
import com.texelsaurus.minecraft.chameleon.service.ChameleonNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoforgeNetworking
implements ChameleonNetworking {
    private static PayloadRegistrar registrar = null;

    public static void init(String modId, ChameleonInit init, NeoforgeRegistryContext context) {
        context.getEventBus().addListener(event -> {
            registrar = event.registrar(modId);
            init.init(context);
            registrar = null;
        });
    }

    @Override
    public <B extends FriendlyByteBuf, P extends ChameleonPacket> void registerPacketInternal(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, boolean clientBound) {
        IPayloadHandler handler = (packet, context) -> packet.handleMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0));
        if (clientBound) {
            registrar.playToClient(payloadType, codec, handler);
        } else {
            registrar.playToServer(payloadType, codec, handler);
        }
    }

    @Override
    public void sendToPlayer(ChameleonPacket packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayersNear(ChameleonPacket packet, ServerLevel level, double x, double y, double z, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)x, (double)y, (double)z, (double)radius, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToServer(ChameleonPacket packet) {
        NeoForgeClient.sendToServer(packet);
    }
}

