/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;

public class BaseBlockEntity
extends class_2586 {
    private class_2487 failureSnapshot;
    private List<BlockEntityDataShim> fixedShims;
    private List<BlockEntityDataShim> portableShims;

    public BaseBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(BlockEntityDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<BlockEntityDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(BlockEntityDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<BlockEntityDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void method_11014(class_11368 input) {
        super.method_11014(input);
        this.readFixed(input);
        this.readPortable(input);
        this.onLoadFinished();
        if (this.field_11863 != null && this.field_11863.method_8608() && this.dataPacketRequiresRenderUpdate()) {
            this.markBlockForRenderUpdate();
        }
    }

    protected void onLoadFinished() {
    }

    public final void read(class_11368 input) {
        this.method_11014(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.writeFixed(output);
        this.writePortable(output);
    }

    public void readPortable(class_11368 input) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                shim.read(input);
            }
        }
    }

    public void writePortable(class_11372 output) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                shim.write(output);
            }
        }
    }

    protected void readFixed(class_11368 input) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                shim.read(input);
            }
        }
    }

    protected void writeFixed(class_11372 output) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                shim.write(output);
            }
        }
    }

    private void trapLoadFailure(Throwable t, class_2487 tag) {
        this.failureSnapshot = tag.method_10553();
    }

    private void restoreLoadFailure(class_2487 tag) {
        for (String key : this.failureSnapshot.method_10541()) {
            if (tag.method_10545(key)) continue;
            tag.method_10566(key, this.failureSnapshot.method_10580(key).method_10707());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    @NotNull
    public final class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_58692(provider);
    }

    public final class_2622 getUpdatePacket() {
        return this.hasDataPacket() ? class_2622.method_38585((class_2586)this) : null;
    }

    public final void onDataPacket(class_2535 net, class_2622 pkt, class_7225.class_7874 lookupProvider) {
        if (pkt != null) {
            this.read(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)lookupProvider, (class_2487)pkt.method_11290()));
        }
        if (this.method_10997() != null && this.method_10997().method_8608() && this.dataPacketRequiresRenderUpdate()) {
            class_2680 state = this.method_10997().method_8320(this.method_11016());
            this.method_10997().method_8413(this.method_11016(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.method_10997() != null && !this.method_10997().method_8608()) {
            class_2680 state = this.method_10997().method_8320(this.field_11867);
            this.method_10997().method_8413(this.field_11867, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.method_10997() != null && this.method_10997().method_8608()) {
            class_2680 state = this.method_10997().method_8320(this.field_11867);
            this.method_10997().method_8413(this.field_11867, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.method_10997() == null) {
            return;
        }
        class_2680 state = this.method_10997().method_8320(this.field_11867);
        this.method_10997().method_8413(this.field_11867, state, state, 2);
    }
}

