/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class DetachedDrawerData
implements IDrawer {
    private class_1799 protoStack;
    private int count;
    private int storageMult;
    private boolean heavy;

    public DetachedDrawerData() {
        this.protoStack = class_1799.field_8037;
        this.count = 0;
        this.storageMult = 1;
        this.heavy = false;
    }

    public DetachedDrawerData(IDrawer sourceDrawer) {
        this(sourceDrawer, 1);
    }

    public DetachedDrawerData(IDrawer sourceDrawer, int storageMult) {
        this.protoStack = sourceDrawer.getStoredItemPrototype();
        this.count = sourceDrawer.getStoredItemCount();
        this.storageMult = storageMult;
    }

    public DetachedDrawerData(class_11368 input) {
        this.deserializeNBT(input);
    }

    protected DetachedDrawerData(DetachedDrawerData data) {
        this.protoStack = data.protoStack;
        this.count = data.count;
        this.storageMult = data.storageMult;
        this.heavy = data.heavy;
    }

    public int getStorageMultiplier() {
        return this.storageMult;
    }

    public void setStorageMultiplier(int storageMult) {
        this.storageMult = storageMult;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setIsHeavy(boolean state) {
        this.heavy = state;
    }

    @Override
    @NotNull
    public class_1799 getStoredItemPrototype() {
        return this.protoStack;
    }

    @Override
    @NotNull
    public IDrawer setStoredItem(@NotNull class_1799 itemPrototype) {
        return this;
    }

    protected IDrawer setStoredItemRaw(@NotNull class_1799 itemPrototype) {
        this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
        this.protoStack.method_7939(1);
        this.count = 0;
        return this;
    }

    @Override
    public int getStoredItemCount() {
        return this.count;
    }

    @Override
    public void setStoredItemCount(int amount) {
    }

    protected void setStoredItemCountRaw(int amount) {
        this.count = amount;
    }

    @Override
    public int getMaxCapacity(@NotNull class_1799 itemPrototype) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getRemainingCapacity() {
        return this.getMaxCapacity() - this.getStoredItemCount();
    }

    @Override
    public boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
        return false;
    }

    @Override
    public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.protoStack.method_7960();
    }

    @Override
    public IDrawer copy() {
        return new DetachedDrawerData(this);
    }

    public void serializeNBT(class_11372 output) {
        if (this.storageMult > 1) {
            output.method_71465("StorageMult", this.storageMult);
        }
        if (this.protoStack.method_7960()) {
            return;
        }
        output.method_71468("Item", class_1799.field_24671, (Object)this.protoStack);
        output.method_71465("Count", this.count);
        if (this.heavy) {
            output.method_71472("Heavy", true);
        }
    }

    public void deserializeNBT(class_11368 input) {
        if (input == null) {
            return;
        }
        this.storageMult = input.method_71424("StorageMult", (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get() * 8);
        this.setIsHeavy(input.method_71433("Heavy", false));
        this.setStoredItemRaw(input.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037));
        this.setStoredItemCountRaw(input.method_71424("Count", 0));
    }
}

