/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import net.minecraft.class_327;

public class CountFormatter {
    public static String format(class_327 font, IDrawer drawer) {
        return CountFormatter.formatApprox(font, drawer);
    }

    public static String format(class_327 font, int itemCount) {
        return CountFormatter.formatApprox(font, itemCount);
    }

    public static String formatStackNotation(IDrawer drawer) {
        if (drawer == null || drawer.isEmpty()) {
            return "";
        }
        return CountFormatter.fromStackNotation(drawer.getStoredItemCount(), drawer.getStoredItemStackSize());
    }

    public static String fromStackNotation(int itemCount, int stackSize) {
        if (itemCount == 0 || stackSize == 0) {
            return "";
        }
        int stacks = itemCount / stackSize;
        int remainder = itemCount - stacks * stackSize;
        Object text = stacks > 0 && remainder > 0 ? stacks + "x" + stackSize + "+" + remainder : (stacks > 0 ? stacks + "x" + stackSize : String.valueOf(remainder));
        return text;
    }

    public static String formatExact(IDrawer drawer) {
        if (drawer == null || drawer.isEmpty()) {
            return "";
        }
        return CountFormatter.formatExact(drawer.getStoredItemCount());
    }

    public static String formatExact(int itemCount) {
        if (itemCount == 0) {
            return "";
        }
        return String.valueOf(itemCount);
    }

    public static String formatApprox(class_327 font, IDrawer drawer) {
        if (drawer == null || drawer.isEmpty()) {
            return "";
        }
        return CountFormatter.formatApprox(font, drawer.getStoredItemCount());
    }

    public static String formatApprox(class_327 font, int count) {
        String text = count >= 1000000000 ? String.format("%.1fG", Float.valueOf((float)count / 1.0E9f)) : (count >= 100000000 ? String.format("%.0fM", Float.valueOf((float)count / 1000000.0f)) : (count >= 1000000 ? String.format("%.1fM", Float.valueOf((float)count / 1000000.0f)) : (count >= 100000 ? String.format("%.0fK", Float.valueOf((float)count / 1000.0f)) : (count >= 10000 ? String.format("%.1fK", Float.valueOf((float)count / 1000.0f)) : String.valueOf(count)))));
        return text;
    }
}

