/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.capabilities.PlatformCapabilities;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.StorageBlacklist;
import com.jaquadro.minecraft.storagedrawers.core.Api;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModNetworking;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.core.PlayerEventListener;
import com.jaquadro.minecraft.storagedrawers.network.PlayerBoolConfigMessage;
import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.registry.ForgeRegistryContext;
import com.texelsaurus.minecraft.chameleon.service.ChameleonConfig;
import com.texelsaurus.minecraft.chameleon.service.ForgeConfig;
import com.texelsaurus.minecraft.chameleon.service.ForgeNetworking;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="storagedrawers")
public class StorageDrawers {
    public static final String MOD_ID = "storagedrawers";
    public static final Api api = new Api();
    public static Logger log = LogManager.getLogger();

    public StorageDrawers() {
        ModCommonConfig.INSTANCE.context().init(MOD_ID, ChameleonConfig.Type.COMMON);
        ModClientConfig.INSTANCE.context().init(MOD_ID, ChameleonConfig.Type.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)((ForgeConfig)ModCommonConfig.INSTANCE.context()).forgeSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)((ForgeConfig)ModClientConfig.INSTANCE.context()).forgeSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeRegistryContext context = new ForgeRegistryContext(bus);
        ModBlocks.init(context);
        ModItems.init(context);
        ModBlockEntities.init(context);
        ModContainers.init(context);
        ModDataComponents.init(context);
        ModRecipes.init(context);
        bus.addListener(this::setup);
        bus.addListener(this::onModConfigEvent);
        bus.addListener(ModCreativeTabs::init);
        bus.addListener(PlatformCapabilities::register);
        ForgeNetworking.init(ModNetworking.INSTANCE, context);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventListener());
    }

    private void setup(FMLCommonSetupEvent event) {
        CompTierRegistry.INSTANCE.initialize();
        StorageBlacklist.INSTANCE.initialize();
        PlatformCapabilities.initHandlers();
        IdMap map = BuiltInRegistries.DATA_COMPONENT_TYPE.asHolderIdMap();
        for (int i = 0; i < map.size(); ++i) {
            ModServices.log.info(i + "=" + String.valueOf(((Holder)map.byId(i)).get()));
        }
        IdMap menumap = BuiltInRegistries.MENU.asHolderIdMap();
        for (int i = 0; i < menumap.size(); ++i) {
            ModServices.log.info(i + "=" + ((Holder)menumap.byId(i)).getRegisteredName());
        }
    }

    private void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            ModCommonConfig.INSTANCE.setLoaded();
        }
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            ModClientConfig.INSTANCE.setLoaded();
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide() || !(event.getEntity() instanceof Player)) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        UUID playerId = Minecraft.getInstance().player.getUUID();
        if (event.getEntity().getUUID() == playerId) {
            ChameleonServices.NETWORK.sendToServer(new PlayerBoolConfigMessage(playerId.toString(), "invertShift", (Boolean)ModClientConfig.INSTANCE.GENERAL.invertShift.get()));
            ChameleonServices.NETWORK.sendToServer(new PlayerBoolConfigMessage(playerId.toString(), "invertClick", (Boolean)ModClientConfig.INSTANCE.GENERAL.invertClick.get()));
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

