/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.storage;

import java.util.function.Predicate;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public interface IDrawer {
    @NotNull
    public class_1799 getStoredItemPrototype();

    @NotNull
    public IDrawer setStoredItem(@NotNull class_1799 var1);

    @NotNull
    default public IDrawer setStoredItem(@NotNull class_1799 itemPrototype, int amount) {
        IDrawer drawer = this.setStoredItem(itemPrototype);
        drawer.setStoredItemCount(amount);
        return drawer;
    }

    public int getStoredItemCount();

    public void setStoredItemCount(int var1);

    default public int adjustStoredItemCount(int amount) {
        if (amount > 0) {
            int insert = Math.min(amount, this.getRemainingCapacity());
            this.setStoredItemCount(this.getStoredItemCount() + insert);
            return amount - insert;
        }
        if (amount < 0) {
            int stored = this.getStoredItemCount();
            int destroy = Math.min(Math.abs(amount), this.getStoredItemCount());
            this.setStoredItemCount(stored - destroy);
            return Math.abs(amount + destroy);
        }
        return 0;
    }

    default public int getMaxCapacity() {
        return this.getMaxCapacity(this.getStoredItemPrototype());
    }

    public int getMaxCapacity(@NotNull class_1799 var1);

    default public int getAcceptingMaxCapacity(@NotNull class_1799 itemPrototype) {
        return this.getMaxCapacity(itemPrototype);
    }

    public int getRemainingCapacity();

    default public int getAcceptingRemainingCapacity() {
        return this.getRemainingCapacity();
    }

    default public int getStoredItemStackSize() {
        @NotNull class_1799 protoStack = this.getStoredItemPrototype();
        if (protoStack.method_7960()) {
            return 0;
        }
        return protoStack.method_7909().method_7882();
    }

    public boolean canItemBeStored(@NotNull class_1799 var1, Predicate<class_1799> var2);

    default public boolean canItemBeStored(@NotNull class_1799 itemPrototype) {
        return this.canItemBeStored(itemPrototype, null);
    }

    public boolean canItemBeExtracted(@NotNull class_1799 var1, Predicate<class_1799> var2);

    default public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype) {
        return this.canItemBeExtracted(itemPrototype, null);
    }

    public boolean isEmpty();

    default public boolean isEnabled() {
        return !this.isMissing();
    }

    default public boolean isMissing() {
        return false;
    }

    default public boolean canDetach() {
        return false;
    }

    default public void setDetached(boolean state) {
    }

    public IDrawer copy();
}

