/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked,
IFramedSourceBlock {
    public static final MapCodec<BlockCompDrawers> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("storageUnits").forGetter(BlockDrawers::getStorageUnits), (App)BlockCompDrawers.method_54096()).apply((Applicative)instance, BlockCompDrawers::new));
    public static final class_2754<EnumCompDrawer> SLOTS = class_2754.method_11850((String)"slots", EnumCompDrawer.class);

    public BlockCompDrawers(int drawerCount, boolean halfDepth, int storageUnits, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockCompDrawers(int drawerCount, boolean halfDepth, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, BlockCompDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 16 : 32;
    }

    public BlockCompDrawers(int storageUnits, class_4970.class_2251 properties) {
        super(3, false, storageUnits, properties);
        this.method_9590((class_2680)this.method_9564().method_11657(SLOTS, (Comparable)((Object)EnumCompDrawer.OPEN1)));
    }

    public BlockCompDrawers(class_4970.class_2251 properties) {
        this(3, false, properties);
    }

    public MapCodec<BlockCompDrawers> method_53969() {
        return CODEC;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SLOTS});
    }

    @Override
    protected int getFaceSlot(class_2350 correctSide, @NotNull class_243 normalizedHit) {
        if (!this.hitWithinArea(correctSide, normalizedHit, 0.0625f, 0.9375f)) {
            return super.getFaceSlot(correctSide, normalizedHit);
        }
        if (this.hitWithinY(normalizedHit, 0.5f, 1.0f)) {
            return 0;
        }
        if (this.getDrawerCount() == 2) {
            return 1;
        }
        if (this.getDrawerCount() == 3) {
            if (this.hitWithinX(correctSide, normalizedHit, 0.0f, 0.5f)) {
                return 1;
            }
            return 2;
        }
        return super.getFaceSlot(correctSide, normalizedHit);
    }

    @Override
    public void method_9567(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, class_1309 entity, @NotNull class_1799 stack) {
        super.method_9567(world, pos, state, entity, stack);
        BlockEntityDrawersComp blockEntity = WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityDrawersComp.class);
        if (blockEntity != null) {
            IDrawerGroup group = blockEntity.getGroup();
            for (int i = group.getDrawerCount() - 1; i >= 0; --i) {
                if (group.getDrawer(i).isEmpty()) continue;
                world.method_8652(pos, (class_2680)state.method_11657(SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(i + 1))), 3);
                break;
            }
        }
    }

    public BlockEntityDrawers newBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return (BlockEntityDrawers)ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(this.getDrawerCount()).create(pos, state);
    }

    @Override
    public class_1799 makeFramedItem(class_1799 source, class_1799 matSide, class_1799 matTrim, class_1799 matFront) {
        IFramedBlock frameBlock;
        switch (this.getDrawerCount()) {
            case 2: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_2.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_DRAWERS_2.get();
                break;
            }
            case 3: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_3.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_DRAWERS_3.get();
                break;
            }
            default: {
                IFramedBlock iFramedBlock = frameBlock = null;
            }
        }
        if (frameBlock == null) {
            return class_1799.field_8037;
        }
        return FrameHelper.makeFramedItem(frameBlock, source, matSide, matTrim, matFront);
    }
}

