/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerFramingTable;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_8824;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class BlockEntityFramingTable
extends BaseBlockEntity
implements class_1275 {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_SIDE = 1;
    public static final int SLOT_TRIM = 2;
    public static final int SLOT_FRONT = 3;
    public static final int SLOT_RESULT = 4;
    private final BlockInventory inventory;
    private final MaterialData materialData = new MaterialData();
    protected class_1799 inputStack = class_1799.field_8037;
    protected class_1799 resultStack = class_1799.field_8037;
    private class_2561 name;

    public BlockEntityFramingTable(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        this.injectData(this.materialData);
        this.inventory = new BlockInventory(this);
    }

    public BlockEntityFramingTable(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public static boolean isMaterialSlot(int slotIndex) {
        return slotIndex == 1 || slotIndex == 2 || slotIndex == 3;
    }

    public MaterialData material() {
        return this.materialData;
    }

    public BlockInventory inventory() {
        return this.inventory;
    }

    @Override
    protected void readFixed(class_11368 input) {
        super.readFixed(input);
        this.inputStack = input.method_71426("Input", class_1799.field_24671).orElse(class_1799.field_8037);
        this.resultStack = input.method_71426("Result", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    @Override
    protected void writeFixed(class_11372 output) {
        super.writeFixed(output);
        if (!this.inputStack.method_7960()) {
            output.method_71468("Input", class_1799.field_24671, (Object)this.inputStack);
        }
        if (!this.resultStack.method_7960()) {
            output.method_71468("Result", class_1799.field_24671, (Object)this.resultStack);
        }
    }

    public boolean isItemValidTarget(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (blockItem.method_7711() instanceof IFramedBlock) {
            FrameData data = (FrameData)stack.method_58695((class_9331)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
            if (!data.side().method_7960() && !this.materialData.getSide().method_7960()) {
                return false;
            }
            if (!data.trim().method_7960() && !this.materialData.getTrim().method_7960()) {
                return false;
            }
            return data.front().method_7960() || this.materialData.getFront().method_7960();
        }
        return blockItem.method_7711() instanceof IFramedSourceBlock;
    }

    public static boolean isItemValidMaterial(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2680 state = blockItem.method_7711().method_9564();
        if (state.method_26204().method_9543()) {
            return false;
        }
        if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.restrictFramingMaterials.get()).booleanValue()) {
            return state.method_51367();
        }
        if (!state.method_26225()) {
            return false;
        }
        if (state.method_26193() < 15) {
            return false;
        }
        if (!class_2248.method_9614((class_265)state.method_26201())) {
            return false;
        }
        return !state.method_26167();
    }

    public class_2561 method_5477() {
        return this.name != null ? this.name : class_2561.method_43471((String)"block.storagedrawers.framing_table");
    }

    public class_2561 method_5797() {
        return this.name;
    }

    protected void method_57568(class_9473 input) {
        super.method_57568(input);
        this.name = (class_2561)input.method_58694(class_9334.field_49631);
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49631, (Object)this.name);
    }

    public void method_57569(class_11372 output) {
        output.method_71478("CustomName");
    }

    @Override
    public void readPortable(class_11368 input) {
        super.readPortable(input);
        this.name = BlockEntityFramingTable.method_59894((class_11368)input, (String)"CustomName");
    }

    @Override
    public void writePortable(class_11372 output) {
        super.writePortable(output);
        if (this.name != null) {
            output.method_71477("CustomName", class_8824.field_46597, (Object)this.name);
        }
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        for (int i = 0; i < 4; ++i) {
            class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.inventory().method_5438(i));
        }
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.method_11016();
        return class_238.method_54784((class_2338)pos.method_10069(-1, 0, -1), (class_2338)pos.method_10069(1, 1, 1));
    }

    public static class BlockInventory
    implements class_1263 {
        private BlockEntityFramingTable entity;

        private BlockInventory(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        public int method_5439() {
            return 5;
        }

        public boolean method_5442() {
            if (!this.entity.inputStack.method_7960()) {
                return false;
            }
            if (!this.entity.resultStack.method_7960()) {
                return false;
            }
            if (!this.entity.materialData.getSide().method_7960()) {
                return false;
            }
            if (!this.entity.materialData.getTrim().method_7960()) {
                return false;
            }
            return this.entity.materialData.getFront().method_7960();
        }

        public boolean method_5437(int slotIndex, class_1799 stack) {
            if (slotIndex == 0) {
                return this.entity.isItemValidTarget(stack);
            }
            if (slotIndex == 1 || slotIndex == 2 || slotIndex == 3) {
                return BlockEntityFramingTable.isItemValidMaterial(stack);
            }
            return false;
        }

        public class_1799 method_5438(int slot) {
            return switch (slot) {
                case 0 -> this.entity.inputStack;
                case 3 -> this.entity.materialData.getFront();
                case 1 -> this.entity.materialData.getSide();
                case 2 -> this.entity.materialData.getTrim();
                case 4 -> this.entity.resultStack;
                default -> null;
            };
        }

        public class_1799 method_5434(int slot, int amount) {
            if (slot < 0 || slot > this.method_5439() || amount <= 0) {
                return class_1799.field_8037;
            }
            class_1799 ret = this.method_5438(slot).method_7971(amount);
            this.rebuildResult();
            this.method_5431();
            return ret;
        }

        public class_1799 method_5441(int slot) {
            if (slot < 0 || slot > this.method_5439()) {
                return class_1799.field_8037;
            }
            class_1799 result = this.method_5438(slot);
            this.method_5447(slot, class_1799.field_8037);
            return result;
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot == 4) {
                return;
            }
            switch (slot) {
                case 0: {
                    this.setInputItem(stack);
                    break;
                }
                case 3: {
                    this.entity.materialData.setFront(stack);
                    break;
                }
                case 1: {
                    this.entity.materialData.setSide(stack);
                    break;
                }
                case 2: {
                    this.entity.materialData.setTrim(stack);
                }
            }
            this.method_5431();
        }

        public void method_5431() {
            this.rebuildResult();
            this.entity.method_5431();
        }

        private void setInputItem(class_1799 stack) {
            class_1747 blockItem;
            class_2248 block;
            class_1792 class_17922;
            if (this.entity.field_11863 != null && !stack.method_7960() && (class_17922 = stack.method_7909()) instanceof class_1747 && (block = (blockItem = (class_1747)class_17922).method_7711()) instanceof IFramedBlock) {
                IFramedBlock fb = (IFramedBlock)block;
                FrameData data = (FrameData)stack.method_58695((class_9331)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
                if (fb.supportsFrameMaterial(FrameMaterial.SIDE) && !this.entity.materialData.getSide().method_7960() && !data.side().method_7960()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.TRIM) && !this.entity.materialData.getTrim().method_7960() && !data.trim().method_7960()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.FRONT) && !this.entity.materialData.getFront().method_7960() && !data.front().method_7960()) {
                    this.entity.resultStack = stack;
                    return;
                }
                class_1799 source = data.base();
                if (!source.method_7960()) {
                    source.method_57381((class_9331)ModDataComponents.FRAME_DATA.get());
                    int count = stack.method_7947();
                    this.entity.inputStack = stack.method_60503((class_1935)source.method_7909());
                    this.entity.materialData.setSide(fb.supportsFrameMaterial(FrameMaterial.SIDE) ? data.side().method_46651(count) : class_1799.field_8037);
                    this.entity.materialData.setTrim(fb.supportsFrameMaterial(FrameMaterial.TRIM) ? data.trim().method_46651(count) : class_1799.field_8037);
                    this.entity.materialData.setFront(fb.supportsFrameMaterial(FrameMaterial.FRONT) ? data.front().method_46651(count) : class_1799.field_8037);
                    return;
                }
            }
            this.entity.inputStack = stack;
        }

        private void rebuildResult() {
            class_1747 blockItem;
            class_2248 block;
            class_1792 class_17922;
            class_1799 target = this.method_5438(0);
            if (target.method_7960()) {
                this.entity.resultStack = class_1799.field_8037;
                return;
            }
            class_1799 matSide = this.method_5438(1);
            class_1799 matTrim = this.method_5438(2);
            class_1799 matFront = this.method_5438(3);
            if (!target.method_7960() && (class_17922 = target.method_7909()) instanceof class_1747 && (block = (blockItem = (class_1747)class_17922).method_7711()) instanceof IFramedSourceBlock) {
                IFramedSourceBlock fsb = (IFramedSourceBlock)block;
                this.entity.resultStack = matSide.method_7960() ? class_1799.field_8037 : fsb.makeFramedItem(target, matSide, matTrim, matFront);
            }
            int count = this.entity.resultStack.method_7947();
            if (!matSide.method_7960()) {
                count = Math.min(count, matSide.method_7947());
            }
            if (!matTrim.method_7960()) {
                count = Math.min(count, matTrim.method_7947());
            }
            if (!matFront.method_7960()) {
                count = Math.min(count, matFront.method_7947());
            }
            this.entity.resultStack.method_7939(count);
        }

        public boolean method_5443(class_1657 player) {
            return class_1263.method_49105((class_2586)this.entity, (class_1657)player);
        }

        public void method_5448() {
            this.entity.inputStack = class_1799.field_8037;
            this.entity.resultStack = class_1799.field_8037;
            this.entity.materialData.clear();
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityFramingTable entity;

        public ContentProvider(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(class_3222 player) {
            return new PositionContent(this.entity.method_11016());
        }

        public class_2561 method_5476() {
            return this.entity.method_5476();
        }

        @Nullable
        public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return new ContainerFramingTable((class_3917)ModContainers.FRAMING_TABLE.get(), id, inventory, this.entity);
        }
    }
}

