/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.CompactingHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackTagMatcher;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;

public class FractionalDrawerGroup
extends BlockEntityDataShim
implements IDrawerGroup {
    private final FractionalStorage storage;
    private final FractionalDrawer[] slots;
    private final int[] order;

    public FractionalDrawerGroup(int slotCount) {
        this.storage = new FractionalStorage(this, slotCount);
        this.slots = new FractionalDrawer[slotCount];
        this.order = new int[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = new FractionalDrawer(this.storage, i);
            this.order[i] = i;
        }
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @NotNull
    public IFractionalDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED_FRACTIONAL;
        }
        return this.slots[slot];
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    public int getPooledCount() {
        return this.storage.getPooledCount();
    }

    public void setPooledCount(int count) {
        this.storage.setPooledCount(count);
    }

    @Override
    public void read(class_11368 input) {
        input.method_71420("Drawers").ifPresent(this.storage::deserializeNBT);
    }

    @Override
    public void write(class_11372 output) {
        this.storage.serializeNBT(output.method_71461("Drawers"));
    }

    public void syncAttributes() {
        this.storage.syncAttributes();
    }

    protected class_1937 getWorld() {
        return null;
    }

    protected void log(String message) {
    }

    protected int getStackCapacity() {
        return 0;
    }

    protected void onItemChanged() {
    }

    protected void onAmountChanged() {
    }

    private static class FractionalStorage {
        private final FractionalDrawerGroup group;
        private final int slotCount;
        private final class_1799[] protoStack;
        private final int[] convRate;
        private final ItemStackMatcher[] matchers;
        private int pooledCount;
        private class_1799 cacheKey = class_1799.field_8037;
        private final class_1799[] cachedProtoStack;
        private final int[] cachedConvRate;
        private final ItemStackMatcher[] cachedMatchers;
        IDrawerAttributes cachedAttrs;

        public FractionalStorage(FractionalDrawerGroup group, int slotCount) {
            this.group = group;
            this.slotCount = slotCount;
            this.protoStack = new class_1799[slotCount];
            this.matchers = new ItemStackMatcher[slotCount];
            this.cachedProtoStack = new class_1799[slotCount];
            this.cachedMatchers = new ItemStackMatcher[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.protoStack[i] = class_1799.field_8037;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.cachedProtoStack[i] = class_1799.field_8037;
                this.cachedMatchers[i] = ItemStackMatcher.EMPTY;
            }
            this.convRate = new int[slotCount];
            this.cachedConvRate = new int[slotCount];
        }

        @NotNull
        IDrawerAttributes getAttributes() {
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            this.cachedAttrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            return EmptyDrawerAttributes.EMPTY;
        }

        public int getPooledCount() {
            return this.pooledCount;
        }

        public void setPooledCount(int count) {
            if (this.pooledCount != count) {
                this.pooledCount = count;
                this.group.onAmountChanged();
            }
        }

        @NotNull
        public class_1799 getStack(int slot) {
            return this.protoStack[slot];
        }

        @NotNull
        public class_1799 baseStack() {
            return this.protoStack[0];
        }

        public int baseRate() {
            return this.convRate[0];
        }

        public IFractionalDrawer setStoredItem(int slot, @NotNull class_1799 itemPrototype) {
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).method_7960()) {
                this.reset();
                return this.group.getDrawer(slot);
            }
            if (this.baseRate() == 0) {
                this.populateSlots(itemPrototype);
                for (int i = 0; i < this.slotCount; ++i) {
                    if (!ItemStackMatcher.areItemsEqual(this.protoStack[i], itemPrototype)) continue;
                    slot = i;
                    this.pooledCount = 0;
                }
                this.group.onItemChanged();
            }
            return this.group.getDrawer(slot);
        }

        public int getStoredCount(int slot) {
            if (this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.pooledCount / this.convRate[slot];
        }

        public void setStoredItemCount(int slot, int amount) {
            if (this.convRate[slot] == 0) {
                return;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return;
            }
            int oldCount = this.pooledCount;
            this.pooledCount = this.pooledCount % this.convRate[slot] + this.convRate[slot] * amount;
            this.pooledCount = Math.min(this.pooledCount, this.getMaxCapacity(0) * this.convRate[0]);
            this.pooledCount = Math.max(this.pooledCount, 0);
            if (this.pooledCount == oldCount) {
                return;
            }
            if (this.pooledCount == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset();
            } else {
                this.group.onAmountChanged();
            }
        }

        public int adjustStoredItemCount(int slot, int amount) {
            if (this.convRate[slot] == 0 || amount == 0) {
                return Math.abs(amount);
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (amount > 0) {
                int canAdd;
                int willAdd;
                if (attrs.isUnlimitedVending()) {
                    return 0;
                }
                int poolMax = this.getMaxCapacity(0) * this.convRate[0];
                if (poolMax < 0) {
                    poolMax = Integer.MAX_VALUE;
                }
                if ((willAdd = Math.min(amount, canAdd = (poolMax - this.pooledCount) / this.convRate[slot])) > 0) {
                    this.pooledCount += this.convRate[slot] * willAdd;
                    this.group.onAmountChanged();
                }
                if (attrs.isVoid()) {
                    return 0;
                }
                return amount - willAdd;
            }
            int canRemove = this.pooledCount / this.convRate[slot];
            int willRemove = Math.min(amount = -amount, canRemove);
            if (willRemove == 0) {
                return amount;
            }
            this.pooledCount -= willRemove * this.convRate[slot];
            if (this.pooledCount == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset();
            } else {
                this.group.onAmountChanged();
            }
            return amount - willRemove;
        }

        public int getMaxCapacity(int slot) {
            if (this.baseStack().method_7960() || this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE / this.convRate[slot];
            }
            int maxSize = ItemStackHelper.getMaxStackSize(this.baseStack());
            return maxSize * this.group.getStackCapacity() * (this.baseRate() / this.convRate[slot]);
        }

        public int getMaxCapacity(int slot, @NotNull class_1799 itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                if (this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / this.convRate[slot];
            }
            if (this.baseStack().method_7960()) {
                int itemStackLimit = 64;
                if (!itemPrototype.method_7960()) {
                    itemStackLimit = ItemStackHelper.getMaxStackSize(itemPrototype);
                }
                return itemStackLimit * this.group.getStackCapacity();
            }
            if (ItemStackMatcher.areItemsEqual(this.protoStack[slot], itemPrototype)) {
                return this.getMaxCapacity(slot);
            }
            return 0;
        }

        public int getAcceptingMaxCapacity(int slot, @NotNull class_1799 itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(slot, itemPrototype);
        }

        public int getRemainingCapacity(int slot) {
            if (this.baseStack().method_7960() || this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            int rawMaxCapacity = this.getMaxCapacity(0) * this.baseRate();
            int rawRemaining = rawMaxCapacity - this.pooledCount;
            return rawRemaining / this.convRate[slot];
        }

        public int getAcceptingRemainingCapacity(int slot) {
            if (this.baseStack().method_7960() || this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending() || attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            int rawMaxCapacity = this.getMaxCapacity(0) * this.baseRate();
            int rawRemaining = rawMaxCapacity - this.pooledCount;
            return rawRemaining / this.convRate[slot];
        }

        public boolean isEmpty(int slot) {
            return this.protoStack[slot].method_7960();
        }

        public boolean isEnabled(int slot) {
            if (this.baseStack().method_7960()) {
                return true;
            }
            return !this.protoStack[slot].method_7960();
        }

        public boolean canItemBeStored(int slot, @NotNull class_1799 itemPrototype, Predicate<class_1799> predicate) {
            IDrawerAttributes attrs = this.getAttributes();
            if (this.protoStack[slot].method_7960() && this.protoStack[0].method_7960() && !attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (predicate == null) {
                return this.matchers[slot].matches(itemPrototype);
            }
            return predicate.test(this.protoStack[slot]);
        }

        public boolean canItemBeExtracted(int slot, @NotNull class_1799 itemPrototype, Predicate<class_1799> predicate) {
            if (this.protoStack[slot].method_7960()) {
                return false;
            }
            if (predicate == null) {
                return this.matchers[slot].matches(itemPrototype);
            }
            return predicate.test(this.protoStack[slot]);
        }

        public int getConversionRate(int slot) {
            if (this.baseStack().method_7960() || this.convRate[slot] == 0) {
                return 0;
            }
            return this.convRate[0] / this.convRate[slot];
        }

        public int getStoredItemRemainder(int slot) {
            if (this.convRate[slot] == 0) {
                return 0;
            }
            if (slot == 0) {
                return this.pooledCount / this.baseRate();
            }
            return this.pooledCount / this.convRate[slot] % (this.convRate[slot - 1] / this.convRate[slot]);
        }

        public boolean isSmallestUnit(int slot) {
            if (this.baseStack().method_7960() || this.convRate[slot] == 0) {
                return false;
            }
            return this.convRate[slot] == 1;
        }

        private void reset() {
            this.pooledCount = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = class_1799.field_8037;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.convRate[i] = 0;
            }
            this.group.onItemChanged();
        }

        private void populateSlotsFromCache() {
            for (int slot = 0; slot < this.slotCount; ++slot) {
                this.protoStack[slot] = this.cachedProtoStack[slot];
                this.convRate[slot] = this.cachedConvRate[slot];
                this.matchers[slot] = this.cachedMatchers[slot];
            }
        }

        private void populateSlots(@NotNull class_1799 itemPrototype) {
            int i;
            int index;
            CompactingHelper.Result lookup;
            IDrawerAttributes attrs = this.getAttributes();
            class_1937 world = this.group.getWorld();
            if (world == null) {
                this.protoStack[0] = itemPrototype;
                this.convRate[0] = 1;
                this.matchers[0] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[0]) : new ItemStackMatcher(this.protoStack[0]);
                return;
            }
            if (ItemStackMatcher.areItemsEqual(itemPrototype, this.cacheKey)) {
                this.populateSlotsFromCache();
                return;
            }
            this.cacheKey = itemPrototype;
            CompactingHelper compacting = new CompactingHelper(world);
            Stack<CompactingHelper.Result> resultStack = new Stack<CompactingHelper.Result>();
            class_1799 lookupTarget = itemPrototype;
            for (int i2 = 0; i2 < this.slotCount - 1 && !(lookup = compacting.findHigherTier(lookupTarget)).getStack().method_7960(); ++i2) {
                resultStack.push(lookup);
                lookupTarget = lookup.getStack();
            }
            int n = resultStack.size();
            for (index = 0; index < n; ++index) {
                CompactingHelper.Result result = (CompactingHelper.Result)resultStack.pop();
                this.populateRawSlot(index, result.getStack(), result.getSize());
                this.group.log("Picked candidate " + result.getStack().toString() + " with conv=" + result.getSize());
                for (i = 0; i < index; ++i) {
                    int n2 = i;
                    this.convRate[n2] = this.convRate[n2] * result.getSize();
                    this.cachedConvRate[i] = this.convRate[i];
                }
            }
            if (index == this.slotCount) {
                return;
            }
            this.populateRawSlot(index++, itemPrototype, 1);
            lookupTarget = itemPrototype;
            while (index < this.slotCount) {
                CompactingHelper.Result lookup2 = compacting.findLowerTier(lookupTarget);
                class_1799 itemStack = lookup2.getStack();
                if (!itemStack.method_7960()) {
                    this.populateRawSlot(index, itemStack, 1);
                    this.group.log("Picked candidate " + String.valueOf(itemStack) + " with conv=" + lookup2.getSize());
                    for (i = 0; i < index; ++i) {
                        int n3 = i;
                        this.convRate[n3] = this.convRate[n3] * lookup2.getSize();
                        this.cachedConvRate[i] = this.convRate[i];
                    }
                } else {
                    this.populateRawSlot(index, class_1799.field_8037, 0);
                }
                lookupTarget = itemStack;
                ++index;
            }
        }

        private void populateRawSlot(int slot, @NotNull class_1799 itemPrototype, int rate) {
            this.protoStack[slot] = itemPrototype;
            this.convRate[slot] = rate;
            IDrawerAttributes attrs = this.getAttributes();
            this.matchers[slot] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[slot]) : new ItemStackMatcher(this.protoStack[slot]);
            this.cachedProtoStack[slot] = itemPrototype;
            this.cachedConvRate[slot] = rate;
            this.cachedMatchers[slot] = this.matchers[slot];
        }

        private void normalizeGroup() {
            int i;
            for (int limit = this.slotCount - 1; limit > 0; --limit) {
                for (i = 0; i < limit; ++i) {
                    if (!this.protoStack[i].method_7960()) continue;
                    this.protoStack[i] = this.protoStack[i + 1];
                    this.matchers[i] = this.matchers[i + 1];
                    this.convRate[i] = this.convRate[i + 1];
                    this.protoStack[i + 1] = class_1799.field_8037;
                    this.matchers[i + 1] = ItemStackMatcher.EMPTY;
                    this.convRate[i + 1] = 0;
                }
            }
            int minConvRate = Integer.MAX_VALUE;
            for (i = 0; i < this.slotCount; ++i) {
                if (this.convRate[i] <= 0) continue;
                minConvRate = Math.min(minConvRate, this.convRate[i]);
            }
            if (minConvRate > 1) {
                i = 0;
                while (i < this.slotCount) {
                    int n = i++;
                    this.convRate[n] = this.convRate[n] / minConvRate;
                }
                this.pooledCount /= minConvRate;
            }
        }

        public void serializeNBT(class_11372 output) {
            class_11372.class_11374 itemList = output.method_71476("Items");
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.protoStack[i].method_7960()) continue;
                class_11372 slotTag = itemList.method_71480();
                slotTag.method_71468("Item", class_1799.field_24671, (Object)this.protoStack[i]);
                slotTag.method_71462("Slot", (byte)i);
                slotTag.method_71465("Conv", this.convRate[i]);
            }
            output.method_71465("Count", this.pooledCount);
        }

        public void deserializeNBT(class_11368 input) {
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = class_1799.field_8037;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.convRate[i] = 0;
            }
            this.pooledCount = input.method_71424("Count", 0);
            class_11368.class_11370 itemList = input.method_71438("Items");
            for (class_11368 slotTag : itemList) {
                int slot = slotTag.method_71424("Slot", 0);
                this.protoStack[slot] = slotTag.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037);
                this.convRate[slot] = slotTag.method_71424("Conv", 0);
                IDrawerAttributes attrs = this.getAttributes();
                this.matchers[slot] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[slot]) : new ItemStackMatcher(this.protoStack[slot]);
            }
            this.normalizeGroup();
            if (!itemList.method_71444()) {
                boolean cacheMatch = true;
                for (int i = 0; i < this.slotCount; ++i) {
                    cacheMatch &= ItemStackMatcher.areItemsEqual(this.protoStack[i], this.cachedProtoStack[i]);
                    cacheMatch &= this.convRate[i] == this.cachedConvRate[i];
                }
                if (!cacheMatch) {
                    this.cacheKey = class_1799.field_8037;
                }
            }
        }

        public void syncAttributes() {
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.protoStack[i].method_7960()) continue;
                IDrawerAttributes attrs = this.getAttributes();
                this.matchers[i] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[i]) : new ItemStackMatcher(this.protoStack[i]);
            }
        }
    }

    private static class FractionalDrawer
    implements IFractionalDrawer {
        private final FractionalStorage storage;
        private final int slot;

        private FractionalDrawer(FractionalStorage storage, int slot) {
            this.storage = storage;
            this.slot = slot;
        }

        private FractionalDrawer(FractionalDrawer data) {
            this(data.storage, data.slot);
        }

        @Override
        @NotNull
        public class_1799 getStoredItemPrototype() {
            return this.storage.getStack(this.slot);
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull class_1799 itemPrototype) {
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            return this.storage.setStoredItem(this.slot, itemPrototype);
        }

        @Override
        public int getStoredItemCount() {
            return this.storage.getStoredCount(this.slot);
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.storage.setStoredItemCount(this.slot, amount);
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.storage.adjustStoredItemCount(this.slot, amount);
        }

        @Override
        public int getMaxCapacity() {
            return this.storage.getMaxCapacity(this.slot);
        }

        @Override
        public int getMaxCapacity(@NotNull class_1799 itemPrototype) {
            return this.storage.getMaxCapacity(this.slot, itemPrototype);
        }

        @Override
        public int getAcceptingMaxCapacity(@NotNull class_1799 itemPrototype) {
            return this.storage.getAcceptingMaxCapacity(this.slot, itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            return this.storage.getRemainingCapacity(this.slot);
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            return this.storage.getAcceptingRemainingCapacity(this.slot);
        }

        @Override
        public boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return this.storage.canItemBeStored(this.slot, itemPrototype, matchPredicate);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return this.storage.canItemBeExtracted(this.slot, itemPrototype, matchPredicate);
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty(this.slot);
        }

        @Override
        public boolean isEnabled() {
            return this.storage.isEnabled(this.slot);
        }

        @Override
        public int getConversionRate() {
            return this.storage.getConversionRate(this.slot);
        }

        @Override
        public int getStoredItemRemainder() {
            return this.storage.getStoredItemRemainder(this.slot);
        }

        @Override
        public boolean isSmallestUnit() {
            return this.storage.isSmallestUnit(this.slot);
        }

        @Override
        public IFractionalDrawer copy() {
            return new FractionalDrawer(this);
        }
    }
}

