/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSized;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedOpen;
import com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedSlotted;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;

public class DrawerModelStore {
    public static final FrameMatSet FramedStandardDrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_DRAWERS_SIDE).trimPart(DynamicPart.FRAMED_DRAWERS_TRIM).frontPart(DynamicPart.FRAMED_DRAWERS_FRONT).shadeFrontPart(DynamicPart.FRAMED_DRAWERS_SHADING);
    public static final FrameMatSet FramedComp2DrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_COMP2_SIDE).trimPart(DynamicPart.FRAMED_COMP2_TRIM).frontPart(DynamicPart.FRAMED_COMP2_FRONT).shadeFrontPart(DynamicPart.FRAMED_COMP2_SHADING);
    public static final FrameMatSet FramedComp3DrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_COMP3_SIDE).trimPart(DynamicPart.FRAMED_COMP3_TRIM).frontPart(DynamicPart.FRAMED_COMP3_FRONT).shadeFrontPart(DynamicPart.FRAMED_COMP3_SHADING);
    public static final FrameMatSet FramedControllerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_CONTROLLER_SIDE).trimPart(DynamicPart.FRAMED_CONTROLLER_TRIM).frontPart(DynamicPart.FRAMED_CONTROLLER_FRONT).shadeFrontPart(DynamicPart.FRAMED_CONTROLLER_SHADING);
    public static final FrameMatSet FramedControllerIOMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_CONTROLLER_IO_SIDE).trimPart(DynamicPart.FRAMED_CONTROLLER_IO_TRIM).shadeFrontPart(DynamicPart.FRAMED_CONTROLLER_IO_SHADING);
    public static final FrameMatSet FramedTrimMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_TRIM_SIDE).trimPart(DynamicPart.FRAMED_TRIM_TRIM);
    private static final Map<class_2680, class_1087> modelStore = new HashMap<class_2680, class_1087>();
    private static final Set<class_2680> locationStore = new HashSet<class_2680>();
    public static final DecorationSet INSTANCE = new DecorationSet();
    private static final DynamicPart[] missingSlots1 = new DynamicPart[]{DynamicPart.MISSING_1};
    private static final DynamicPart[] missingSlots2 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2};
    private static final DynamicPart[] missingSlots4 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2, DynamicPart.MISSING_3, DynamicPart.MISSING_4};
    public static final DynamicPart[][] missingSlots = new DynamicPart[][]{missingSlots1, missingSlots2, new DynamicPart[0], missingSlots4};

    static class_2680 addLocation(class_2680 loc) {
        locationStore.add(loc);
        modelStore.put(loc, null);
        return loc;
    }

    static String getVariant() {
        return "";
    }

    static String getVariant(class_2350 dir) {
        return "facing=" + dir.method_10151();
    }

    static String getVariant(class_2350 dir, boolean half) {
        return "facing=" + dir.method_10151() + ",half=" + half;
    }

    static String getVariant(class_2350 dir, boolean half, int slots) {
        return "facing=" + dir.method_10151() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(class_2350 dir, boolean half, EnumCompDrawer slots) {
        return "facing=" + dir.method_10151() + ",half=" + half + ",slots=" + String.valueOf(slots);
    }

    static String getVariant(DynamicPart part) {
        return "part=" + part.getName();
    }

    static String getVariant(DynamicPart part, class_2350 dir) {
        return "part=" + part.getName() + ",facing=" + dir.method_10151();
    }

    static String getVariant(DynamicPart part, class_2350 dir, boolean half) {
        return "part=" + part.getName() + ",facing=" + dir.method_10151() + ",half=" + half;
    }

    static String getVariant(DynamicPart part, class_2350 dir, boolean half, int slots) {
        return "part=" + part.getName() + ",facing=" + dir.method_10151() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(DynamicPart part, class_2350 dir, boolean half, EnumCompDrawer slots) {
        return "part=" + part.getName() + ",facing=" + dir.method_10151() + ",half=" + half + ",slots=" + String.valueOf(slots);
    }

    public static Stream<class_2680> getModelLocations() {
        return locationStore.stream();
    }

    public static void tryAddModel(class_2680 loc, class_1087 model) {
        if (loc == null) {
            return;
        }
        if (modelStore.containsKey(loc)) {
            modelStore.put(loc, model);
        }
    }

    public static class_1087 getModel(class_2680 state) {
        if (state == null) {
            return null;
        }
        class_1087 storedModel = modelStore.getOrDefault(state, null);
        if (storedModel == null) {
            return class_310.method_1551().method_1554().method_4743().method_3335(state);
        }
        return storedModel;
    }

    public static class_1087 getModel(String variant) {
        return DrawerModelStore.getModel(DrawerModelStore.INSTANCE.overlays.getOrDefault(variant, null));
    }

    public static class_1087 getModel(DynamicPart part) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part));
    }

    public static class_1087 getModel(DynamicPart part, class_2350 dir) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir));
    }

    public static class_1087 getModel(DynamicPart part, class_2350 dir, boolean half) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half));
    }

    public static class_1087 getModel(DynamicPart part, class_2350 dir, boolean half, int slots) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half, slots));
    }

    public static class_1087 getModel(DynamicPart part, class_2350 dir, boolean half, EnumCompDrawer slots) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half, slots));
    }

    static {
        for (int i = 0; i < 4; ++i) {
            class_2350 dir = class_2350.method_10139((int)i);
            INSTANCE.add(dir, true);
            INSTANCE.add(dir, false);
        }
    }

    public static enum DynamicPart {
        LOCK("lock"),
        CLAIM("claim"),
        LOCK_CLAIM("lock_claim"),
        VOID("void"),
        SHROUD("shroud"),
        INDICATOR("indicator"),
        INDICATOR_COMP("indicator_comp"),
        PRIORITY_P1("priority_p1"),
        PRIORITY_P2("priority_p2"),
        PRIORITY_N1("priority_n1"),
        PRIORITY_N2("priority_n2"),
        MISSING_1("missing_1"),
        MISSING_2("missing_2"),
        MISSING_3("missing_3"),
        MISSING_4("missing_4"),
        FRAMED_DRAWERS_SIDE("framed_drawers_side"),
        FRAMED_DRAWERS_TRIM("framed_drawers_trim"),
        FRAMED_DRAWERS_FRONT("framed_drawers_front"),
        FRAMED_DRAWERS_SHADING("framed_drawers_shading"),
        FRAMED_TRIM_SIDE("framed_trim_side"),
        FRAMED_TRIM_TRIM("framed_trim_trim"),
        FRAMED_CONTROLLER_SIDE("framed_controller_side"),
        FRAMED_CONTROLLER_TRIM("framed_controller_trim"),
        FRAMED_CONTROLLER_FRONT("framed_controller_front"),
        FRAMED_CONTROLLER_SHADING("framed_controller_shading"),
        FRAMED_CONTROLLER_IO_SIDE("framed_controller_io_side"),
        FRAMED_CONTROLLER_IO_TRIM("framed_controller_io_trim"),
        FRAMED_CONTROLLER_IO_SHADING("framed_controller_io_shading"),
        FRAMED_COMP2_SIDE("framed_comp2_side"),
        FRAMED_COMP2_TRIM("framed_comp2_trim"),
        FRAMED_COMP2_FRONT("framed_comp2_front"),
        FRAMED_COMP2_SHADING("framed_comp2_shading"),
        FRAMED_COMP3_SIDE("framed_comp3_side"),
        FRAMED_COMP3_TRIM("framed_comp3_trim"),
        FRAMED_COMP3_FRONT("framed_comp3_front"),
        FRAMED_COMP3_SHADING("framed_comp3_shading");

        private String name;

        private DynamicPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class DecorationSet {
        public final Set<class_2680> targetBlocks = new HashSet<class_2680>();
        public final Map<String, class_2680> overlays = new HashMap<String, class_2680>();

        public DecorationSet() {
            ModBlocks.getDrawersOfType(BlockDrawers.class).forEach(blockDrawers -> this.targetBlocks.addAll((Collection<class_2680>)blockDrawers.method_9595().method_11662()));
            ModBlocks.getFramedBlocks().forEach(blockTrim -> {
                if (blockTrim instanceof class_2248) {
                    class_2248 mcBlock = (class_2248)blockTrim;
                    this.targetBlocks.addAll((Collection<class_2680>)mcBlock.method_9595().method_11662());
                }
            });
        }

        public void add(class_2350 dir, boolean half) {
            EnumCompDrawer open;
            int i;
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.LOCK, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_LOCKED.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.CLAIM, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_CLAIMED.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.LOCK_CLAIM, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_LOCKED_CLAIMED.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.VOID, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_VOID.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.SHROUD, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_SHROUD.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 1), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_INDICATOR.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 2), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_INDICATOR.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 4), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_INDICATOR.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR_COMP, dir, half, 2), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_COMP_INDICATOR.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR_COMP, dir, half, 3), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_COMP_INDICATOR.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(3)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_P1, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_PRIORITY_P1.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_P2, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_PRIORITY_P2.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_N1, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_PRIORITY_N1.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_N2, dir, half), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_PRIORITY_N2.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 1), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_1_1.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 2), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_2_1.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 4), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_4_1.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_2, dir, half, 2), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_2_2.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_2, dir, half, 4), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_4_2.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_3, dir, half, 4), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_4_3.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_4, dir, half, 4), (class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_MISSING_4_4.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 1), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SIDE.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 2), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SIDE.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 4), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SIDE.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 1), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_TRIM.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 2), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_TRIM.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 4), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_TRIM.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 1), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_FRONT.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 2), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_FRONT.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 4), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_FRONT.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 1), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SHADING.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 2), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SHADING.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 4), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_DRAWERS_SHADING.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657((class_2769)BlockMetaFacingSizedSlotted.SLOTS, (Comparable)Integer.valueOf(4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_TRIM_SIDE), ((BlockMeta)((Object)ModBlocks.META_FRAMED_TRIM_SIDE.get())).method_9564());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_TRIM_TRIM), ((BlockMeta)((Object)ModBlocks.META_FRAMED_TRIM_TRIM.get())).method_9564());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_SIDE, dir), (class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_SIDE.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_TRIM, dir), (class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_TRIM.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_FRONT, dir), (class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_FRONT.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_SHADING, dir), (class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_SHADING.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_SIDE), ((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_IO_SIDE.get())).method_9564());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_TRIM), ((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_IO_TRIM.get())).method_9564());
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_SHADING), ((BlockMeta)((Object)ModBlocks.META_FRAMED_CONTROLLER_IO_SHADING.get())).method_9564());
            for (i = 1; i <= 2; ++i) {
                open = EnumCompDrawer.byOpenSlots(i);
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_SIDE, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_SIDE.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_TRIM, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_TRIM.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_FRONT, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_FRONT.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_SHADING, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_2_SHADING.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
            }
            for (i = 1; i <= 3; ++i) {
                open = EnumCompDrawer.byOpenSlots(i);
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_SIDE, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_SIDE.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_TRIM, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_TRIM.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_FRONT, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_FRONT.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_SHADING, dir, half, open), (class_2680)((class_2680)((class_2680)((BlockMeta)((Object)ModBlocks.META_FRAMED_COMPDRAWERS_3_SHADING.get())).method_9564().method_11657((class_2769)BlockMetaFacingSized.FACING, (Comparable)dir)).method_11657((class_2769)BlockMetaFacingSized.HALF, (Comparable)Boolean.valueOf(half))).method_11657(BlockMetaFacingSizedOpen.SLOTS, (Comparable)((Object)open)));
            }
        }

        void addOverlay(String variant, class_2680 loc) {
            this.overlays.put(variant, DrawerModelStore.addLocation(loc));
        }

        public boolean isTargetedModel(class_2680 loc) {
            if (loc == null) {
                return false;
            }
            return this.targetBlocks.contains(loc);
        }
    }

    public static class FrameMatSet {
        private DynamicPart sidePart;
        private DynamicPart trimPart;
        private DynamicPart frontPart;
        private DynamicPart shadeFrontPart;
        private DynamicPart shadeSidePart;

        public DynamicPart sidePart() {
            return this.sidePart;
        }

        public DynamicPart trimPart() {
            return this.trimPart;
        }

        public DynamicPart frontPart() {
            return this.frontPart;
        }

        public DynamicPart shadeFrontPart() {
            return this.shadeFrontPart;
        }

        public DynamicPart shadeSidePart() {
            return this.shadeSidePart;
        }

        public FrameMatSet sidePart(DynamicPart part) {
            this.sidePart = part;
            return this;
        }

        public FrameMatSet trimPart(DynamicPart part) {
            this.trimPart = part;
            return this;
        }

        public FrameMatSet frontPart(DynamicPart part) {
            this.frontPart = part;
            return this;
        }

        public FrameMatSet shadeFrontPart(DynamicPart part) {
            this.shadeFrontPart = part;
            return this;
        }

        public FrameMatSet shadeSidePart(DynamicPart part) {
            this.shadeSidePart = part;
            return this;
        }
    }
}

