/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.base.Suppliers;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.DrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ItemModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DecoratorRenderType;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements FabricBlockStateModel {
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;
    private final class_1799 stack;
    private static Map<class_1087, Mesh> meshCache = new HashMap<class_1087, Mesh>();
    private static final List<DecoratorRenderType> decoratorRenderTypes = List.of(DecoratorRenderType.SOLID, DecoratorRenderType.CUTOUT, DecoratorRenderType.TRANSLUCENT);

    public PlatformDecoratedModel(class_1087 parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
        this.stack = null;
    }

    public PlatformDecoratedModel(PlatformDecoratedModel<C> p, class_1799 stack) {
        super(p.parent);
        this.decorator = p.decorator;
        this.contextSupplier = p.contextSupplier;
        this.stack = stack;
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        if (state == null) {
            this.parent.emitQuads(emitter, blockView, pos, null, random, cullTest);
            return;
        }
        class_1920 fabricView = blockView;
        if (fabricView == null) {
            return;
        }
        Object renderData = fabricView.getBlockEntityRenderData(pos);
        Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(state, random, renderData);
        if (this.decorator.shouldRenderBase(supplier)) {
            this.parent.emitQuads(emitter, blockView, pos, state, random, cullTest);
        }
        Consumer<class_1087> emitModelOpaque = model -> {
            if (model != null) {
                model.emitQuads(emitter, blockView, pos, state, random, cullTest);
            }
        };
        Consumer<class_1087> emitModelCutout = model -> {
            if (model != null) {
                Mesh mesh = this.getMesh((class_1087)model, state, random, DecoratorRenderType.CUTOUT);
                mesh.outputTo(emitter);
            }
        };
        Consumer<class_1087> emitModelTransparent = model -> {
            if (model != null) {
                Mesh mesh = this.getMesh((class_1087)model, state, random, DecoratorRenderType.TRANSLUCENT);
                mesh.outputTo(emitter);
            }
        };
        try {
            this.decorator.emitQuads(supplier, emitModelOpaque, DecoratorRenderType.SOLID);
            this.decorator.emitQuads(supplier, emitModelCutout, DecoratorRenderType.CUTOUT);
            this.decorator.emitQuads(supplier, emitModelTransparent, DecoratorRenderType.TRANSLUCENT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Mesh getMesh(class_1087 model, class_2680 state, class_5819 randomSource, DecoratorRenderType renderType) {
        if (meshCache.containsKey(model)) {
            return meshCache.get(model);
        }
        Mesh mesh = this.buildMesh(model, state, randomSource, renderType);
        meshCache.put(model, mesh);
        return mesh;
    }

    private Mesh buildMesh(class_1087 model, class_2680 state, class_5819 randomSource, DecoratorRenderType renderType) {
        Renderer render = Renderer.get();
        MutableMesh builder = render.mutableMesh();
        QuadEmitter quadEmit = builder.emitter().renderLayer(DecoratorRenderType.toChunkType(renderType));
        ArrayList parts = new ArrayList();
        model.method_68513(randomSource, parts);
        for (class_10889 part : parts) {
            for (class_2350 d : class_2350.values()) {
                for (class_777 quad : part.method_68509(d)) {
                    quadEmit.fromBakedQuad(quad).emit();
                }
            }
            for (class_777 quad : part.method_68509(null)) {
                quadEmit.fromBakedQuad(quad).emit();
            }
        }
        return builder.immutableCopy();
    }

    public class_1058 particleSprite(class_1920 blockView, class_2338 pos, class_2680 state) {
        class_1792 class_17922;
        class_1799 side;
        if (blockView == null) {
            return super.particleSprite(null, pos, state);
        }
        Object renderData = blockView.getBlockEntityRenderData(pos);
        MaterialData matData = null;
        if (renderData instanceof DrawerModelProperties) {
            DrawerModelProperties drawerProps = (DrawerModelProperties)renderData;
            matData = new MaterialData(drawerProps.material);
        } else if (renderData instanceof FramedModelProperties) {
            FramedModelProperties frameProps = (FramedModelProperties)renderData;
            matData = new MaterialData(frameProps.material);
        }
        if (matData != null && (side = matData.getEffectiveSide()) != class_1799.field_8037 && (class_17922 = side.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_1087 model = class_310.method_1551().method_1541().method_3349(blockItem.method_7711().method_9564());
            return model.method_68511();
        }
        return super.particleSprite(blockView, pos, state);
    }

    public static class PlatformDecoratedItemModel
    implements class_10439 {
        private final class_2960 location;
        private final String variant;
        private final class_10809 properties;
        private final Supplier<Vector3f[]> extents;
        PlatformDecoratedModel<? extends ModelContext> parent;
        class_1087 model;
        class_1799 stack;
        class_2680 state;

        public PlatformDecoratedItemModel(class_2960 location, String variant, class_10809 properties) {
            this.location = location;
            this.variant = variant;
            this.properties = properties;
            this.extents = Suppliers.memoize(() -> {
                Vector3f[] ext = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
                return ext;
            });
        }

        public void method_65584(class_10444 itemStackRenderState, class_1799 itemStack, class_10442 itemModelResolver, class_811 itemDisplayContext, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity, int i) {
            class_1087 stored;
            itemStackRenderState.method_70946((Object)this);
            itemStackRenderState.method_70946((Object)itemStack);
            if (this.state == null) {
                String[] props;
                Optional blockOption = class_7923.field_41175.method_10223(this.location);
                if (blockOption.isEmpty()) {
                    return;
                }
                class_2248 block = (class_2248)((class_6880.class_6883)blockOption.get()).comp_349();
                this.state = block.method_9564();
                for (String prop : props = this.variant.split(",")) {
                    String[] keyVal = prop.split("=");
                    if (keyVal.length != 2) continue;
                    String key = keyVal[0].trim();
                    String value = keyVal[1].trim();
                    class_2769 property = this.state.method_26204().method_9595().method_11663(key);
                    if (property == null) continue;
                    this.state = PlatformDecoratedItemModel.setProperty(this.state, property, value);
                }
            }
            if (!(this.stack != null && class_1799.method_31577((class_1799)this.stack, (class_1799)itemStack) || this.parent == null)) {
                this.stack = itemStack;
                this.model = new PlatformDecoratedModel<ModelContext>(this.parent, itemStack);
            }
            if (this.parent == null && (stored = ItemModelStore.models.get(this.state)) instanceof PlatformDecoratedModel) {
                PlatformDecoratedModel p;
                this.parent = p = (PlatformDecoratedModel)stored;
            }
            if (this.model != null) {
                HashMap<DecoratorRenderType, class_10444.class_10446> layers = new HashMap<DecoratorRenderType, class_10444.class_10446>();
                for (DecoratorRenderType renderType : decoratorRenderTypes) {
                    ArrayList parts = new ArrayList();
                    Consumer<class_1087> emitModel = model -> {
                        if (model != null) {
                            model.method_68513(null, parts);
                        }
                    };
                    PlatformDecoratedModel<? extends ModelContext> pd = this.parent;
                    Supplier<ModelContext> supplier = () -> pd.contextSupplier.makeContext(this.stack);
                    pd.decorator.emitItemQuads(supplier, emitModel, this.stack, renderType);
                    if (parts.isEmpty()) continue;
                    if (!layers.containsKey((Object)renderType)) {
                        class_10444.class_10446 renderState = itemStackRenderState.method_65601();
                        layers.put(renderType, renderState);
                        renderState.method_67992(DecoratorRenderType.toItemType(renderType));
                        renderState.method_67995(this.extents);
                    }
                    for (class_10889 part : parts) {
                        class_10444.class_10446 layer = (class_10444.class_10446)layers.get((Object)renderType);
                        this.properties.method_68000(layer, itemDisplayContext);
                        layer.method_67997().addAll(part.method_68509(null));
                        for (class_2350 direction : class_2350.values()) {
                            layer.method_67997().addAll(part.method_68509(direction));
                        }
                    }
                }
            }
        }

        private static <T extends Comparable<T>> class_2680 setProperty(class_2680 state, class_2769<T> property, String valueName) {
            Optional parsed = property.method_11900(valueName);
            return parsed.map(v -> (class_2680)state.method_11657(property, v)).orElse(state);
        }

        public record Unbaked(class_2960 model, String variant) implements class_10439.class_10441
        {
            public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.fieldOf("model").forGetter(Unbaked::model), (App)Codec.STRING.fieldOf("variant").forGetter(Unbaked::variant)).apply((Applicative)builder, Unbaked::new));

            public MapCodec<? extends class_10439.class_10441> method_65585() {
                return MAP_CODEC;
            }

            public class_10439 method_65587(class_10439.class_10440 bakingContext) {
                class_7775 modelbaker = bakingContext.comp_3390();
                class_10819 resolvedmodel = modelbaker.method_45872(class_2960.method_60655((String)"storagedrawers", (String)"block/oak_full_drawers_2"));
                class_10419 textureslots = resolvedmodel.method_68045();
                class_10809 modelrenderproperties = class_10809.method_68001((class_7775)modelbaker, (class_10819)resolvedmodel, (class_10419)textureslots);
                return new PlatformDecoratedItemModel(this.model, this.variant, modelrenderproperties);
            }

            public void method_62326(class_10526.class_10103 resolver) {
                resolver.markDependency(this.model);
                resolver.markDependency(class_2960.method_60655((String)"storagedrawers", (String)"block/oak_full_drawers_2"));
            }
        }
    }
}

