/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpriteReplacementModel
extends ParentModel {
    private class_1058 sprite;
    private Map<class_10889, ReplacementBlockPart> cache = new HashMap<class_10889, ReplacementBlockPart>();

    public SpriteReplacementModel(@NotNull class_1087 parent, class_1058 sprite) {
        super(parent);
        this.sprite = sprite;
    }

    public SpriteReplacementModel(@NotNull class_1087 parent, class_1799 stack) {
        super(parent);
        class_1792 class_17922;
        if (stack != null && (class_17922 = stack.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            class_776 disp = class_310.method_1551().method_1541();
            class_1087 model = disp.method_3349(block.method_9564());
            this.sprite = model.method_68511();
        }
    }

    @Override
    public void method_68513(class_5819 randomSource, List<class_10889> list) {
        if (this.sprite == null) {
            super.method_68513(randomSource, list);
            return;
        }
        this.parent.method_68512(randomSource).forEach(part -> {
            if (this.cache.containsKey(part)) {
                list.add(this.cache.get(part));
            } else {
                ReplacementBlockPart replacement = new ReplacementBlockPart((class_10889)part, this.sprite);
                if (this.cache.size() < 10) {
                    this.cache.put((class_10889)part, replacement);
                }
                list.add(replacement);
            }
        });
    }

    @Override
    public class_1058 method_68511() {
        if (this.sprite == null) {
            return super.method_68511();
        }
        return this.sprite;
    }

    private static class ReplacementBlockPart
    implements class_10889 {
        private class_10889 parent;
        private class_1058 sprite;
        private List<class_777> quads = new ArrayList<class_777>();

        public ReplacementBlockPart(class_10889 part, class_1058 sprite) {
            this.parent = part;
            this.sprite = sprite;
            part.method_68509(null).forEach(quad -> this.quads.add(this.remapQuad((class_777)quad, sprite)));
            for (class_2350 dir : class_2350.values()) {
                part.method_68509(dir).forEach(quad -> this.quads.add(this.remapQuad((class_777)quad, sprite)));
            }
        }

        public List<class_777> method_68509(@Nullable class_2350 direction) {
            return this.quads;
        }

        public boolean comp_3751() {
            return this.parent.comp_3751();
        }

        public class_1058 comp_3752() {
            if (this.sprite == null) {
                return this.parent.comp_3752();
            }
            return this.sprite;
        }

        class_777 remapQuad(class_777 quad, class_1058 sprite) {
            int[] vertices = (int[])quad.comp_3721().clone();
            for (int i = 0; i < 4; ++i) {
                int blk = class_290.field_1590.getVertexSize() / 4 * i;
                int offset = class_290.field_1590.getOffset(VertexFormatElement.UV) / 4;
                vertices[blk + offset] = Float.floatToRawIntBits(sprite.method_4580(this.getUnInterpolatedU(quad.comp_3724(), Float.intBitsToFloat(vertices[blk + offset]))));
                vertices[blk + offset + 1] = Float.floatToRawIntBits(sprite.method_4570(this.getUnInterpolatedV(quad.comp_3724(), Float.intBitsToFloat(vertices[blk + offset + 1]))));
            }
            return new class_777(vertices, quad.comp_3722(), quad.comp_3723(), sprite, quad.comp_3725(), quad.comp_3726());
        }

        private float getUnInterpolatedU(class_1058 sprite, float u) {
            float diff = sprite.method_4577() - sprite.method_4594();
            return (u - sprite.method_4594()) / diff;
        }

        private float getUnInterpolatedV(class_1058 sprite, float v) {
            float diff = sprite.method_4575() - sprite.method_4593();
            return (v - sprite.method_4593()) / diff;
        }
    }
}

