/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DecoratorRenderType;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class DrawerModelDecorator
extends ModelDecorator<DrawerModelContext> {
    protected final DrawerModelStore.DecorationSet overlays;
    private static final List<DecoratorRenderType> defaultRenderTypes = List.of(DecoratorRenderType.CUTOUT);

    public DrawerModelDecorator(DrawerModelStore.DecorationSet overlays) {
        this.overlays = overlays;
    }

    @Override
    public List<DecoratorRenderType> getRenderTypes(class_2680 state) {
        return defaultRenderTypes;
    }

    @Override
    public void emitQuads(Supplier<DrawerModelContext> contextSupplier, Consumer<class_1087> emitModel, DecoratorRenderType renderType) {
        DrawerModelContext context = contextSupplier.get();
        if (context == null) {
            return;
        }
        if (renderType == null || renderType == DecoratorRenderType.CUTOUT) {
            this.emitDecoratedQuads(context, emitModel, renderType);
        }
    }

    public void emitDecoratedQuads(DrawerModelContext context, Consumer<class_1087> emitModel, DecoratorRenderType renderType) {
        IDrawerGroup group;
        DrawerModelStore.DynamicPart priorityPart;
        boolean isClaimed;
        IDrawerAttributes attr;
        class_2350 dir = (class_2350)context.state().method_11654((class_2769)BlockDrawers.field_11177);
        boolean half = false;
        class_2248 block = context.state().method_26204();
        if (block instanceof BlockDrawers) {
            BlockDrawers drawers = (BlockDrawers)block;
            half = drawers.isHalfDepth();
        }
        if ((attr = context.attr()) == null) {
            return;
        }
        IProtectable protectable = context.protectable();
        boolean isLocked = attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED);
        boolean bl = isClaimed = protectable != null && protectable.getOwner() != null;
        if (isLocked && isClaimed) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.LOCK_CLAIM, dir, half));
        } else if (isLocked) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.LOCK, dir, half));
        } else if (isClaimed) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.CLAIM, dir, half));
        }
        switch (attr.getPriority()) {
            case 1: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_P1;
                break;
            }
            case 2: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_P2;
                break;
            }
            case -1: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_N1;
                break;
            }
            case -2: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_N2;
                break;
            }
            default: {
                DrawerModelStore.DynamicPart dynamicPart = priorityPart = null;
            }
        }
        if (priorityPart != null) {
            emitModel.accept(DrawerModelStore.getModel(priorityPart, dir, half));
        }
        if (attr.isVoid()) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.VOID, dir, half));
        }
        if (attr.isConcealed()) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.SHROUD, dir, half));
        }
        if (attr.hasFillLevel()) {
            if (block instanceof BlockCompDrawers) {
                BlockCompDrawers compBlock = (BlockCompDrawers)block;
                count = compBlock.getDrawerCount();
                emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.INDICATOR_COMP, dir, half, count));
            } else if (block instanceof BlockStandardDrawers) {
                BlockStandardDrawers stdBlock = (BlockStandardDrawers)block;
                count = stdBlock.getDrawerCount();
                emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.INDICATOR, dir, half, count));
            }
        }
        if (block instanceof BlockStandardDrawers && (group = context.group()) != null) {
            int count = group.getDrawerCount();
            DrawerModelStore.DynamicPart[] groupMissingSlots = DrawerModelStore.missingSlots[count - 1];
            for (int i = 0; i < groupMissingSlots.length; ++i) {
                if (!group.getDrawer(i).isMissing()) continue;
                emitModel.accept(DrawerModelStore.getModel(groupMissingSlots[i], dir, half, count));
            }
        }
    }
}

