/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerStorageImpl;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class DrawerStackStorage
extends SingleStackStorage {
    DrawerStorageImpl storage;
    int slot;
    class_1799 lastReleasedSnapshot = null;

    DrawerStackStorage(DrawerStorageImpl storage, int slot) {
        this.storage = storage;
        this.slot = slot;
    }

    void updateSlot(int slot) {
        this.slot = slot;
    }

    protected class_1799 getStack() {
        IDrawer drawer = this.storage.getDrawer(this.slot);
        return drawer.getStoredItemPrototype().method_46651(drawer.getStoredItemCount());
    }

    protected void setStack(class_1799 stack) {
        if (stack.method_7947() > 0) {
            this.storage.getDrawer(this.slot).setStoredItem(stack, stack.method_7947());
        } else {
            this.storage.getDrawer(this.slot).setStoredItemCount(0);
        }
    }

    protected int getCapacity(ItemVariant itemVariant) {
        return this.storage.getDrawer(this.slot).getMaxCapacity(itemVariant.toStack());
    }

    private IDrawerAttributes getDrawerAttributes(IDrawerGroup group) {
        if (group == null) {
            return null;
        }
        IDrawerAttributes attr = group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attr == null && group instanceof BlockEntityDrawers) {
            attr = ((BlockEntityDrawers)group).getDrawerAttributes();
        }
        return attr;
    }

    private boolean checkControllerVoid(BlockEntityController controller) {
        if (controller == null) {
            return false;
        }
        IDrawer drawer = this.storage.getDrawer(this.slot);
        if (drawer == null || !drawer.isEnabled()) {
            return false;
        }
        IDrawerGroup drawerGroup = controller.getGroupForDrawerSlot(this.slot);
        if (drawerGroup == null) {
            return false;
        }
        IDrawerAttributes attrs = this.getDrawerAttributes(drawerGroup);
        return attrs != null && attrs.isVoid();
    }

    public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        if (!this.storage.getDrawer(this.slot).canItemBeStored(insertedVariant.toStack())) {
            return 0L;
        }
        long inserted = super.insert(insertedVariant, maxAmount, transaction);
        if (inserted < maxAmount) {
            boolean isVoid;
            if (this.storage.group instanceof BlockEntityController) {
                isVoid = this.checkControllerVoid((BlockEntityController)this.storage.group);
            } else if (this.storage.group instanceof BlockEntityControllerIO) {
                BlockEntityController controller = ((BlockEntityControllerIO)this.storage.group).getController();
                isVoid = this.checkControllerVoid(controller);
            } else {
                IDrawerAttributes attr = this.getDrawerAttributes(this.storage.group);
                boolean bl = isVoid = attr != null && attr.isVoid();
            }
            if (isVoid) {
                inserted = maxAmount;
            }
        }
        return inserted;
    }

    public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
        if (!this.storage.getDrawer(this.slot).canItemBeExtracted(variant.toStack())) {
            return 0L;
        }
        return super.extract(variant, maxAmount, transaction);
    }

    protected void releaseSnapshot(class_1799 snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    protected void onFinalCommit() {
        class_1799 original = this.lastReleasedSnapshot;
        class_1799 currentStack = this.getStack();
        if (!original.method_7960() && original.method_7909() == currentStack.method_7909()) {
            if (!Objects.equals(original.method_57380(), currentStack.method_57380())) {
                for (class_9331 type : original.method_57353().method_57831()) {
                    original.method_57379(type, null);
                }
                original.method_57365(currentStack.method_57353());
            }
            original.method_7939(currentStack.method_7947());
            this.setStack(original);
        } else {
            original.method_7939(0);
        }
    }
}

